/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.kafka;

import io.atleon.core.Contextual;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;
import reactor.kafka.sender.SenderRecord;

final class ContextualProducer<K, V>
implements Producer<K, V> {
    private final Producer<K, V> delegate;

    public ContextualProducer(Producer<K, V> delegate) {
        this.delegate = delegate;
    }

    public void initTransactions() {
        this.delegate.initTransactions();
    }

    public void beginTransaction() throws ProducerFencedException {
        this.delegate.beginTransaction();
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) throws ProducerFencedException {
        this.delegate.sendOffsetsToTransaction(offsets, consumerGroupId);
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) throws ProducerFencedException {
        this.delegate.sendOffsetsToTransaction(offsets, groupMetadata);
    }

    public void commitTransaction() throws ProducerFencedException {
        this.delegate.commitTransaction();
    }

    public void abortTransaction() throws ProducerFencedException {
        this.delegate.abortTransaction();
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
        Object correlationMetadata = ((SenderRecord)SenderRecord.class.cast(record)).correlationMetadata();
        return correlationMetadata instanceof Contextual ? (Future)((Contextual)Contextual.class.cast(correlationMetadata)).supplyInContext(() -> this.delegate.send(record)) : this.delegate.send(record);
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> record, Callback callback) {
        Object correlationMetadata = ((SenderRecord)SenderRecord.class.cast(record)).correlationMetadata();
        return correlationMetadata instanceof Contextual ? (Future)((Contextual)Contextual.class.cast(correlationMetadata)).supplyInContext(() -> this.delegate.send(record, callback)) : this.delegate.send(record, callback);
    }

    public void flush() {
        this.delegate.flush();
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return this.delegate.partitionsFor(topic);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.delegate.metrics();
    }

    public void close() {
        this.delegate.close();
    }

    public void close(Duration timeout) {
        this.delegate.close(timeout);
    }
}

