/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.kafka;

import io.atleon.kafka.MachineData;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractPartitionAssignor;
import org.apache.kafka.common.TopicPartition;

public final class SingleMachinePartitionAssignor
extends AbstractPartitionAssignor {
    private static final MachineData MACHINE_DATA = MachineData.birth();

    public ByteBuffer subscriptionUserData(Set<String> topics) {
        return MACHINE_DATA.toByteBuffer();
    }

    public Map<String, List<TopicPartition>> assign(Map<String, Integer> partitionCounts, Map<String, ConsumerPartitionAssignor.Subscription> subscriptionsByMemberId) {
        Map machineMemberDataByTopic = subscriptionsByMemberId.entrySet().stream().flatMap(it -> this.streamTopicMachineMemberData((String)it.getKey(), (ConsumerPartitionAssignor.Subscription)it.getValue())).collect(Collectors.groupingBy(TopicMachineMemberData::topic, Collectors.mapping(TopicMachineMemberData::machineMemberData, Collectors.toList())));
        Map<String, List> memberIdsToAssignByTopic = machineMemberDataByTopic.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> this.chooseMemberIdsToAssign((List)it.getValue())));
        Map<String, List<TopicPartition>> assignments = memberIdsToAssignByTopic.entrySet().stream().flatMap(it -> this.assign((String)it.getKey(), partitionCounts.getOrDefault(it.getKey(), 0), (List)it.getValue())).collect(Collectors.groupingBy(AssignedTopicPartition::memberId, Collectors.mapping(AssignedTopicPartition::topicPartition, Collectors.toList())));
        subscriptionsByMemberId.keySet().forEach(it -> assignments.putIfAbsent((String)it, Collections.emptyList()));
        return assignments;
    }

    public String name() {
        return "singlemachine";
    }

    public short version() {
        return 1;
    }

    private Stream<TopicMachineMemberData> streamTopicMachineMemberData(String memberId, ConsumerPartitionAssignor.Subscription subscription) {
        MachineData machineData = MachineData.fromByteBuffer(subscription.userData());
        return subscription.topics().stream().map(it -> new TopicMachineMemberData((String)it, machineData, memberId));
    }

    private List<String> chooseMemberIdsToAssign(List<MachineMemberData> machineMemberData) {
        Map memberIdsByMachineData = machineMemberData.stream().collect(Collectors.groupingBy(MachineMemberData::machineData, Collectors.mapping(MachineMemberData::memberId, Collectors.toList())));
        memberIdsByMachineData.values().forEach(it -> it.sort(Comparator.naturalOrder()));
        return memberIdsByMachineData.keySet().stream().min(Comparator.comparing(MachineData::birthTime).thenComparing(MachineData::id)).map(memberIdsByMachineData::get).orElse(Collections.emptyList());
    }

    private Stream<AssignedTopicPartition> assign(String topic, int partitionCount, List<String> memberIds) {
        return IntStream.range(0, partitionCount).mapToObj(it -> new AssignedTopicPartition((String)memberIds.get(it % memberIds.size()), topic, it));
    }

    private static final class AssignedTopicPartition {
        private final String memberId;
        private final TopicPartition topicPartition;

        public AssignedTopicPartition(String memberId, String topic, int partition) {
            this.memberId = memberId;
            this.topicPartition = new TopicPartition(topic, partition);
        }

        public String memberId() {
            return this.memberId;
        }

        public TopicPartition topicPartition() {
            return this.topicPartition;
        }
    }

    private static final class TopicMachineMemberData {
        private final String topic;
        private final MachineMemberData machineMemberData;

        public TopicMachineMemberData(String topic, MachineData machineData, String memberId) {
            this.topic = topic;
            this.machineMemberData = new MachineMemberData(machineData, memberId);
        }

        public String topic() {
            return this.topic;
        }

        public MachineMemberData machineMemberData() {
            return this.machineMemberData;
        }
    }

    private static final class MachineMemberData {
        private final MachineData machineData;
        private final String memberId;

        public MachineMemberData(MachineData machineData, String memberId) {
            this.machineData = machineData;
            this.memberId = memberId;
        }

        public MachineData machineData() {
            return this.machineData;
        }

        public String memberId() {
            return this.memberId;
        }
    }
}

