/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.kafka;

import io.atleon.kafka.OffsetCriteria;
import io.atleon.kafka.OffsetRange;
import io.atleon.kafka.RawOffsetRange;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;

@FunctionalInterface
public interface OffsetRangeProvider {
    public static OffsetRangeProvider earliestToLatestFromAllTopicPartitions() {
        return OffsetRangeProvider.inOffsetRangeFromAllTopicPartitions(OffsetCriteria.earliest().to(OffsetCriteria.latest()));
    }

    public static OffsetRangeProvider inOffsetRangeFromAllTopicPartitions(OffsetRange offsetRange) {
        return __ -> Optional.of(offsetRange);
    }

    public static OffsetRangeProvider inOffsetRangeFromTopicPartition(TopicPartition topicPartition, OffsetRange offsetRange) {
        return OffsetRangeProvider.inOffsetRangesFromTopicPartitions(Collections.singletonMap(topicPartition, offsetRange));
    }

    public static OffsetRangeProvider inOffsetRangesFromTopicPartitions(Map<TopicPartition, OffsetRange> offsetRanges) {
        return it -> Optional.ofNullable((OffsetRange)offsetRanges.get(it));
    }

    public static OffsetRangeProvider inOffsetRangeFromTopicPartition(TopicPartition topicPartition, long rawOffset, OffsetCriteria maxInclusive) {
        return OffsetRangeProvider.inOffsetRangeFromTopicPartition(topicPartition, OffsetCriteria.raw(rawOffset).to(maxInclusive));
    }

    public static OffsetRangeProvider startingFromRawOffsetInTopicPartition(TopicPartition topicPartition, long rawOffset, OffsetRange offsetRange) {
        return new StartingFromRawOffsetInTopicPartition(topicPartition, rawOffset, offsetRange);
    }

    public static OffsetRangeProvider usingRawOffsetRange(TopicPartition topicPartition, RawOffsetRange rawOffsetRange) {
        return OffsetRangeProvider.usingRawOffsetRanges(Collections.singletonMap(topicPartition, rawOffsetRange));
    }

    public static OffsetRangeProvider usingRawOffsetRanges(Map<TopicPartition, RawOffsetRange> rawOffsetRangesByTopicPartition) {
        return it -> Optional.ofNullable((RawOffsetRange)rawOffsetRangesByTopicPartition.get(it)).map(RawOffsetRange::toOffsetRange);
    }

    public Optional<OffsetRange> forTopicPartition(TopicPartition var1);

    default public Comparator<? super TopicPartition> topicPartitionComparator() {
        return Comparator.comparing(TopicPartition::topic).thenComparing(TopicPartition::partition);
    }

    public static final class StartingFromRawOffsetInTopicPartition
    implements OffsetRangeProvider {
        private final TopicPartition startingTopicPartition;
        private final long startingRawOffset;
        private final OffsetRange offsetRange;

        private StartingFromRawOffsetInTopicPartition(TopicPartition topicPartition, long rawOffset, OffsetRange offsetRange) {
            this.startingTopicPartition = topicPartition;
            this.startingRawOffset = rawOffset;
            this.offsetRange = offsetRange;
        }

        @Override
        public Optional<OffsetRange> forTopicPartition(TopicPartition topicPartition) {
            int comparison = this.topicPartitionComparator().compare((TopicPartition)this.startingTopicPartition, (TopicPartition)topicPartition);
            if (comparison == 0) {
                return Optional.of(OffsetCriteria.raw(this.startingRawOffset).to(this.offsetRange.maxInclusive()));
            }
            return comparison < 0 ? Optional.of(this.offsetRange) : Optional.empty();
        }
    }
}

