/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.kafka;

import io.atleon.util.ConfigLoading;
import io.atleon.util.Configurable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class KafkaConfig {
    private final Map<String, ?> properties;

    protected KafkaConfig(Map<String, ?> properties) {
        this.properties = properties;
    }

    public static KafkaConfig create(Map<String, ?> properties) {
        return new KafkaConfig(properties);
    }

    public KafkaConfig withClientIdSuffix(String delimiter, String suffix) {
        Map<String, Object> modifiedProperties = this.modifyAndGetProperties(it -> it.computeIfPresent("client.id", (__, id) -> id + delimiter + suffix));
        return new KafkaConfig(modifiedProperties);
    }

    public Map<String, Object> nativeProperties() {
        return ConfigLoading.loadNative(this.properties);
    }

    public Map<String, Object> modifyAndGetProperties(Consumer<Map<String, Object>> modifier) {
        HashMap<String, Object> modifiedProperties = new HashMap<String, Object>(this.properties);
        modifier.accept(modifiedProperties);
        return modifiedProperties;
    }

    public <T extends Configurable> Optional<T> loadConfiguredWithPredefinedTypes(String key, Class<? extends T> type, Function<String, Optional<T>> predefinedTypeInstantiator) {
        return ConfigLoading.loadConfiguredWithPredefinedTypes(this.properties, (String)key, type, predefinedTypeInstantiator);
    }

    public Optional<Duration> loadDuration(String property) {
        return ConfigLoading.loadDuration(this.properties, (String)property);
    }

    public Optional<Boolean> loadBoolean(String property) {
        return ConfigLoading.loadBoolean(this.properties, (String)property);
    }

    public Optional<Integer> loadInt(String property) {
        return ConfigLoading.loadInt(this.properties, (String)property);
    }

    public Optional<Long> loadLong(String property) {
        return ConfigLoading.loadLong(this.properties, (String)property);
    }

    public Optional<String> loadString(String property) {
        return ConfigLoading.loadString(this.properties, (String)property);
    }

    public <T extends Enum<T>> Optional<T> loadEnum(String property, Class<T> enumType) {
        return ConfigLoading.loadEnum(this.properties, (String)property, enumType);
    }
}

