/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.kafka;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.kafka.receiver.ReceiverOptions;
import reactor.kafka.receiver.internals.ConsumerFactory;

class ConsumerMutexEnforcer
extends ConsumerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerMutexEnforcer.class);
    private final AtomicInteger ticketCounter = new AtomicInteger(0);

    ConsumerMutexEnforcer() {
    }

    public final ProhibitableConsumerFactory newConsumerFactory() {
        return new ProhibitableConsumerFactory(this.ticketCounter.incrementAndGet());
    }

    protected <K, V> Consumer<K, V> newConsumer(ReceiverOptions<K, V> options) {
        return new KafkaConsumer(options.consumerProperties(), options.keyDeserializer(), options.valueDeserializer());
    }

    final class ProhibitableConsumerFactory
    extends ConsumerFactory {
        private final int ticket;
        private volatile Instant consumptionDeadline = null;

        private ProhibitableConsumerFactory(int ticket) {
            this.ticket = ticket;
        }

        public <K, V> Consumer<K, V> createConsumer(ReceiverOptions<K, V> config) {
            return new ConsumerProxy<K, V>(config);
        }

        public void prohibitFurtherConsumption(Duration gracePeriod) {
            this.consumptionDeadline = Instant.now().plus(gracePeriod);
        }

        private final class ConsumerProxy<K, V>
        implements Consumer<K, V> {
            private final String clientId;
            private final Consumer<K, V> delegate;

            public ConsumerProxy(ReceiverOptions<K, V> options) {
                this.clientId = options.clientId();
                this.delegate = ConsumerMutexEnforcer.this.newConsumer(options);
            }

            public Set<TopicPartition> assignment() {
                return this.delegate.assignment();
            }

            public Set<String> subscription() {
                return this.delegate.subscription();
            }

            public void subscribe(Collection<String> topics) {
                this.delegate.subscribe(topics);
            }

            public void subscribe(Collection<String> topics, ConsumerRebalanceListener callback) {
                this.delegate.subscribe(topics, callback);
            }

            public void assign(Collection<TopicPartition> partitions) {
                this.delegate.assign(partitions);
            }

            public void subscribe(Pattern pattern, ConsumerRebalanceListener callback) {
                this.delegate.subscribe(pattern, callback);
            }

            public void subscribe(Pattern pattern) {
                this.delegate.subscribe(pattern);
            }

            public void unsubscribe() {
                this.delegate.unsubscribe();
            }

            @Deprecated
            public ConsumerRecords<K, V> poll(long timeout) {
                return this.poll(Duration.ofMillis(timeout));
            }

            public ConsumerRecords<K, V> poll(Duration timeout) {
                return this.invokeIfAllowed(() -> this.delegate.poll(timeout));
            }

            public void commitSync() {
                this.delegate.commitSync();
            }

            public void commitSync(Duration timeout) {
                this.delegate.commitSync(timeout);
            }

            public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
                this.delegate.commitSync(offsets);
            }

            public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets, Duration timeout) {
                this.delegate.commitSync(offsets, timeout);
            }

            public void commitAsync() {
                this.delegate.commitAsync();
            }

            public void commitAsync(OffsetCommitCallback callback) {
                this.delegate.commitAsync(callback);
            }

            public void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
                this.delegate.commitAsync(offsets, callback);
            }

            public void seek(TopicPartition partition, long offset) {
                this.delegate.seek(partition, offset);
            }

            public void seek(TopicPartition partition, OffsetAndMetadata offsetAndMetadata) {
                this.delegate.seek(partition, offsetAndMetadata);
            }

            public void seekToBeginning(Collection<TopicPartition> partitions) {
                this.delegate.seekToBeginning(partitions);
            }

            public void seekToEnd(Collection<TopicPartition> partitions) {
                this.delegate.seekToEnd(partitions);
            }

            public long position(TopicPartition partition) {
                return this.delegate.position(partition);
            }

            public long position(TopicPartition partition, Duration timeout) {
                return this.delegate.position(partition, timeout);
            }

            @Deprecated
            public OffsetAndMetadata committed(TopicPartition partition) {
                return this.delegate.committed(partition);
            }

            @Deprecated
            public OffsetAndMetadata committed(TopicPartition partition, Duration timeout) {
                return this.delegate.committed(partition, timeout);
            }

            public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions) {
                return this.delegate.committed(partitions);
            }

            public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions, Duration timeout) {
                return this.delegate.committed(partitions, timeout);
            }

            public Map<MetricName, ? extends Metric> metrics() {
                return this.delegate.metrics();
            }

            public List<PartitionInfo> partitionsFor(String topic) {
                return this.delegate.partitionsFor(topic);
            }

            public List<PartitionInfo> partitionsFor(String topic, Duration timeout) {
                return this.delegate.partitionsFor(topic, timeout);
            }

            public Map<String, List<PartitionInfo>> listTopics() {
                return this.delegate.listTopics();
            }

            public Map<String, List<PartitionInfo>> listTopics(Duration timeout) {
                return this.delegate.listTopics(timeout);
            }

            public Set<TopicPartition> paused() {
                return this.delegate.paused();
            }

            public void pause(Collection<TopicPartition> partitions) {
                this.delegate.pause(partitions);
            }

            public void resume(Collection<TopicPartition> partitions) {
                this.delegate.resume(partitions);
            }

            public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch) {
                return this.delegate.offsetsForTimes(timestampsToSearch);
            }

            public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch, Duration timeout) {
                return this.delegate.offsetsForTimes(timestampsToSearch, timeout);
            }

            public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions) {
                return this.delegate.beginningOffsets(partitions);
            }

            public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions, Duration timeout) {
                return this.delegate.beginningOffsets(partitions, timeout);
            }

            public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
                return this.delegate.endOffsets(partitions);
            }

            public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions, Duration timeout) {
                return this.delegate.endOffsets(partitions, timeout);
            }

            public OptionalLong currentLag(TopicPartition topicPartition) {
                return this.delegate.currentLag(topicPartition);
            }

            public ConsumerGroupMetadata groupMetadata() {
                return this.delegate.groupMetadata();
            }

            public void enforceRebalance() {
                this.delegate.enforceRebalance();
            }

            public void enforceRebalance(String reason) {
                this.delegate.enforceRebalance(reason);
            }

            public void close() {
                this.delegate.close();
            }

            public void close(Duration timeout) {
                this.delegate.close(timeout);
            }

            public void wakeup() {
                this.delegate.wakeup();
            }

            private <T> T invokeIfAllowed(Supplier<T> supplier) {
                Instant deadline = ProhibitableConsumerFactory.this.consumptionDeadline;
                if (deadline != null && Instant.now().compareTo(deadline) > 0) {
                    IllegalStateException exception = new IllegalStateException("Consumer invocations prohibited, but invoked: " + this.clientId);
                    LOGGER.error(exception.getMessage(), (Throwable)exception);
                    throw exception;
                }
                if (deadline == null && ProhibitableConsumerFactory.this.ticket != ConsumerMutexEnforcer.this.ticketCounter.get()) {
                    IllegalStateException exception = new IllegalStateException("Detected orphaned Consumer instance: " + this.clientId);
                    LOGGER.error(exception.getMessage(), (Throwable)exception);
                    throw exception;
                }
                return supplier.get();
            }
        }
    }
}

