/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.kafka;

import io.atleon.core.ConfigSource;
import io.atleon.util.ConfigLoading;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaConfigSource
extends ConfigSource<Map<String, Object>, KafkaConfigSource> {
    protected KafkaConfigSource() {
    }

    protected KafkaConfigSource(String name) {
        super(name);
    }

    protected KafkaConfigSource(Function<Map<String, Object>, Optional<String>> propertiesToName) {
        super(propertiesToName);
    }

    public static KafkaConfigSource named(String name) {
        return new KafkaConfigSource(name);
    }

    public static KafkaConfigSource useClientIdAsName() {
        return new KafkaConfigSource(properties -> ConfigLoading.load((Map)properties, (String)"client.id", Object::toString));
    }

    public KafkaConfigSource withClientId(String clientId) {
        return (KafkaConfigSource)this.with("client.id", clientId);
    }

    public KafkaConfigSource withBootstrapServers(String bootstrapServers) {
        return (KafkaConfigSource)this.with("bootstrap.servers", bootstrapServers);
    }

    public KafkaConfigSource withProducerOrderingAndResiliencyConfigs() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("max.in.flight.requests.per.connection", 1);
        configs.put("acks", "all");
        return (KafkaConfigSource)this.withAll(configs);
    }

    public KafkaConfigSource withConsumerGroupId(String groupId) {
        return (KafkaConfigSource)this.with("group.id", groupId);
    }

    public KafkaConfigSource withKeySerializer(Class<? extends Serializer<?>> serializerClass) {
        return (KafkaConfigSource)this.with("key.serializer", serializerClass.getName());
    }

    public KafkaConfigSource withValueSerializer(Class<? extends Serializer<?>> serializerClass) {
        return (KafkaConfigSource)this.with("value.serializer", serializerClass.getName());
    }

    public KafkaConfigSource withKeyDeserializer(Class<? extends Deserializer<?>> deserializerClass) {
        return (KafkaConfigSource)this.with("key.deserializer", deserializerClass.getName());
    }

    public KafkaConfigSource withValueDeserializer(Class<? extends Deserializer<?>> deserializerClass) {
        return (KafkaConfigSource)this.with("value.deserializer", deserializerClass.getName());
    }

    protected KafkaConfigSource initializeCopy() {
        return new KafkaConfigSource();
    }

    protected void validateProperties(Map<String, Object> properties) {
        KafkaConfigSource.validateNonNullProperty(properties, (String)"client.id");
        KafkaConfigSource.validateNonNullProperty(properties, (String)"bootstrap.servers");
    }

    protected Map<String, Object> postProcessProperties(Map<String, Object> properties) {
        return properties;
    }
}

