/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.kafka;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;

public final class RecordHeaderConversion {
    private RecordHeaderConversion() {
    }

    public static Header toHeader(String key, String value) {
        return new RecordHeader(key, RecordHeaderConversion.serializeValue(value));
    }

    public static Map<String, String> toMap(Headers headers) {
        return StreamSupport.stream(headers.spliterator(), false).collect(Collectors.toMap(Header::key, header -> RecordHeaderConversion.deserializeValue(header.value()), RecordHeaderConversion.lastValueWins()));
    }

    private static byte[] serializeValue(String value) {
        return value.getBytes(StandardCharsets.UTF_8);
    }

    private static String deserializeValue(byte[] value) {
        return new String(value, StandardCharsets.UTF_8);
    }

    private static BinaryOperator<String> lastValueWins() {
        return (value1, value2) -> value2;
    }
}

