/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.kafka;

import io.atleon.core.Alo;
import java.util.Optional;
import org.apache.kafka.clients.producer.RecordMetadata;
import reactor.kafka.sender.SenderResult;

public class KafkaSenderResult<T> {
    private final RecordMetadata recordMetadata;
    private final Exception exception;
    private final T correlationMetadata;

    private KafkaSenderResult(RecordMetadata recordMetadata, Exception exception, T correlationMetadata) {
        this.recordMetadata = recordMetadata;
        this.exception = exception;
        this.correlationMetadata = correlationMetadata;
    }

    static <T> KafkaSenderResult<T> fromSenderResult(SenderResult<T> senderResult) {
        return new KafkaSenderResult<Object>(senderResult.recordMetadata(), senderResult.exception(), senderResult.correlationMetadata());
    }

    static <T> Alo<KafkaSenderResult<T>> fromSenderResultOfAlo(SenderResult<Alo<T>> senderResult) {
        return ((Alo)senderResult.correlationMetadata()).map(correlationMetadata -> new KafkaSenderResult<Object>(senderResult.recordMetadata(), senderResult.exception(), correlationMetadata));
    }

    public String toString() {
        return "KafkaSenderResult{recordMetadata=" + this.recordMetadata + ", exception=" + this.exception + ", correlationMetadata=" + this.correlationMetadata + '}';
    }

    public Optional<RecordMetadata> recordMetadata() {
        return Optional.ofNullable(this.recordMetadata);
    }

    public Optional<Exception> exception() {
        return Optional.ofNullable(this.exception);
    }

    public T correlationMetadata() {
        return this.correlationMetadata;
    }
}

