/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.kafka;

import io.atleon.core.Alo;
import io.atleon.kafka.KafkaSenderResult;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.BaseSubscriber;

public class DefaultAloKafkaSenderResultSubscriber<T>
extends BaseSubscriber<Alo<KafkaSenderResult<T>>> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultAloKafkaSenderResultSubscriber.class);

    protected void hookOnNext(Alo<KafkaSenderResult<T>> aloResult) {
        KafkaSenderResult result = (KafkaSenderResult)aloResult.get();
        Optional<Exception> error = result.exception();
        if (error.isPresent()) {
            LOGGER.warn("Alo Kafka Sender Result has Error: result={}", (Object)result);
            Alo.nacknowledge(aloResult, (Throwable)error.get());
        } else {
            Alo.acknowledge(aloResult);
        }
    }
}

