/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.kafka.embedded;

import io.atleon.kafka.embedded.EmbeddedKafkaConfig;
import io.atleon.zookeeper.embedded.EmbeddedZooKeeper;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import org.apache.kafka.common.utils.Time;
import scala.Option;

public final class EmbeddedKafka {
    public static final int DEFAULT_PORT = 9092;
    private static EmbeddedKafkaConfig config;

    private EmbeddedKafka() {
    }

    public static String startAndGetBootstrapServersConnect() {
        return EmbeddedKafka.start(9092).getConnect();
    }

    public static String startAndGetBootstrapServersConnect(int port) {
        return EmbeddedKafka.start(port, 2181).getConnect();
    }

    public static String startAndGetBootstrapServersConnect(int port, int zookeeperPort) {
        return EmbeddedKafka.start(port, zookeeperPort).getConnect();
    }

    public static EmbeddedKafkaConfig start() {
        return EmbeddedKafka.start(9092);
    }

    public static EmbeddedKafkaConfig start(int port) {
        return EmbeddedKafka.start(port, 2181);
    }

    public static synchronized EmbeddedKafkaConfig start(int port, int zookeeperPort) {
        return config == null ? (config = EmbeddedKafka.initializeKafka(port, zookeeperPort)) : config;
    }

    private static EmbeddedKafkaConfig initializeKafka(int port, int zookeeperPort) {
        URL zooKeeperConnect = EmbeddedZooKeeper.startAndGetConnectUrl((int)zookeeperPort);
        KafkaConfig kafkaConfig = new KafkaConfig(EmbeddedKafka.createKafkaBrokerConfig(zooKeeperConnect, port), true);
        EmbeddedKafka.startLocalKafka(kafkaConfig);
        return EmbeddedKafkaConfig.fromKafkaConfig(kafkaConfig);
    }

    private static Map<String, Object> createKafkaBrokerConfig(URL zookeeperConnect, int port) {
        HashMap<String, Object> kafkaBrokerConfig = new HashMap<String, Object>();
        kafkaBrokerConfig.put(KafkaConfig.ZkConnectProp(), EmbeddedKafka.extractConnect(zookeeperConnect));
        kafkaBrokerConfig.put(KafkaConfig.ListenersProp(), "PLAINTEXT://localhost:" + port);
        kafkaBrokerConfig.put(KafkaConfig.NumPartitionsProp(), 10);
        kafkaBrokerConfig.put(KafkaConfig.OffsetsTopicReplicationFactorProp(), "1");
        kafkaBrokerConfig.put(KafkaConfig.LogDirProp(), EmbeddedKafka.createLogDirectory().toString());
        return kafkaBrokerConfig;
    }

    private static String extractConnect(URL connectUrl) {
        return connectUrl.getHost() + ":" + connectUrl.getPort();
    }

    private static Path createLogDirectory() {
        try {
            return Files.createTempDirectory(EmbeddedKafka.class.getSimpleName() + "_" + System.currentTimeMillis(), new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create temporary log directory", e);
        }
    }

    private static void startLocalKafka(KafkaConfig kafkaConfig) {
        try {
            new KafkaServer(kafkaConfig, Time.SYSTEM, Option.empty(), false).startup();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not start local Kafka Server", e);
        }
    }
}

