/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.aws.sqs;

import java.time.Duration;
import java.util.function.Supplier;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;

public final class SqsSenderOptions {
    public static final int DEFAULT_BATCH_SIZE = 1;
    public static final Duration DEFAULT_BATCH_DURATION = Duration.ZERO;
    public static final int DEFAULT_BATCH_PREFETCH = 32;
    public static final int DEFAULT_MAX_REQUESTS_IN_FLIGHT = 1;
    private final Supplier<SqsAsyncClient> clientSupplier;
    private final int batchSize;
    private final Duration batchDuration;
    private final int batchPrefetch;
    private final int maxRequestsInFlight;

    private SqsSenderOptions(Supplier<SqsAsyncClient> clientSupplier, int batchSize, Duration batchDuration, int batchPrefetch, int maxRequestsInFlight) {
        this.clientSupplier = clientSupplier;
        this.batchSize = batchSize;
        this.batchDuration = batchDuration;
        this.batchPrefetch = batchPrefetch;
        this.maxRequestsInFlight = maxRequestsInFlight;
    }

    public static SqsSenderOptions defaultOptions(Supplier<SqsAsyncClient> clientSupplier) {
        return SqsSenderOptions.newBuilder(clientSupplier).build();
    }

    public static Builder newBuilder(Supplier<SqsAsyncClient> clientSupplier) {
        return new Builder(clientSupplier);
    }

    public SqsAsyncClient createClient() {
        return this.clientSupplier.get();
    }

    public int batchSize() {
        return this.batchSize;
    }

    public Duration batchDuration() {
        return this.batchDuration;
    }

    public int batchPrefetch() {
        return this.batchPrefetch;
    }

    public int maxRequestsInFlight() {
        return this.maxRequestsInFlight;
    }

    public static final class Builder {
        private final Supplier<SqsAsyncClient> clientSupplier;
        private int batchSize = 1;
        private Duration batchDuration = DEFAULT_BATCH_DURATION;
        private int batchPrefetch = 32;
        private int maxRequestsInFlight = 1;

        private Builder(Supplier<SqsAsyncClient> clientSupplier) {
            this.clientSupplier = clientSupplier;
        }

        public SqsSenderOptions build() {
            return new SqsSenderOptions(this.clientSupplier, this.batchSize, this.batchDuration, this.batchPrefetch, this.maxRequestsInFlight);
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder batchDuration(Duration batchDuration) {
            this.batchDuration = batchDuration;
            return this;
        }

        public Builder batchPrefetch(int batchPrefetch) {
            this.batchPrefetch = batchPrefetch;
            return this;
        }

        public Builder maxRequestsInFlight(int maxRequestsInFlight) {
            this.maxRequestsInFlight = maxRequestsInFlight;
            return this;
        }
    }
}

