/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.aws.sqs;

import io.atleon.aws.sqs.ReceivedSqsMessage;
import io.atleon.aws.sqs.SqsMessageVisibilityChanger;
import io.atleon.util.ConfigLoading;
import io.atleon.util.Configurable;
import java.time.Duration;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;

public interface NacknowledgerFactory<T>
extends Configurable {
    public static final String VISIBILITY_RESET_SECONDS_CONFIG = "sqs.nacknowledger.visibility.reset.seconds";

    default public void configure(Map<String, ?> properties) {
    }

    public Consumer<Throwable> create(ReceivedSqsMessage<T> var1, SqsMessageVisibilityChanger var2, Consumer<Throwable> var3);

    public static final class VisibilityReset<T>
    implements NacknowledgerFactory<T> {
        private final Logger logger;
        private int seconds = 0;

        VisibilityReset(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void configure(Map<String, ?> properties) {
            this.seconds = ConfigLoading.loadInt(properties, (String)NacknowledgerFactory.VISIBILITY_RESET_SECONDS_CONFIG).orElse(this.seconds);
        }

        @Override
        public Consumer<Throwable> create(ReceivedSqsMessage<T> message, SqsMessageVisibilityChanger visibilityChanger, Consumer<Throwable> errorEmitter) {
            String messageId = message.messageId();
            return error -> {
                this.logger.warn("Nacknowledging Message id={} by resetting visibility to {} seconds", new Object[]{messageId, this.seconds, error});
                visibilityChanger.execute(Duration.ofSeconds(this.seconds), false);
            };
        }
    }

    public static final class Emit<T>
    implements NacknowledgerFactory<T> {
        Emit() {
        }

        @Override
        public Consumer<Throwable> create(ReceivedSqsMessage<T> message, SqsMessageVisibilityChanger visibilityChanger, Consumer<Throwable> errorEmitter) {
            return errorEmitter;
        }
    }
}

