/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.aws.sqs;

import io.atleon.aws.sqs.AbstractSqsMessage;
import io.atleon.aws.sqs.ReceivedSqsMessage;
import io.atleon.aws.sqs.SqsMessageVisibilityChanger;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeValue;

public final class SqsReceiverMessage
extends AbstractSqsMessage<String>
implements ReceivedSqsMessage<String> {
    private final String receiptHandle;
    private final String messageId;
    private final Runnable deleter;
    private final SqsMessageVisibilityChanger visibilityChanger;

    private SqsReceiverMessage(String receiptHandle, String messageId, Map<String, MessageAttributeValue> messageAttributes, Map<String, MessageSystemAttributeValue> messageSystemAttributes, String body, Runnable deleter, SqsMessageVisibilityChanger visibilityChanger) {
        super(messageAttributes, messageSystemAttributes, body);
        this.receiptHandle = receiptHandle;
        this.messageId = messageId;
        this.deleter = deleter;
        this.visibilityChanger = visibilityChanger;
    }

    static SqsReceiverMessage create(Message message, Runnable deleter, SqsMessageVisibilityChanger visibilityChanger) {
        return new SqsReceiverMessage(message.receiptHandle(), message.messageId(), message.messageAttributes(), SqsReceiverMessage.toMessageSystemAttributes(message.attributesAsStrings()), message.body(), deleter, visibilityChanger);
    }

    @Override
    public String receiptHandle() {
        return this.receiptHandle;
    }

    @Override
    public String messageId() {
        return this.messageId;
    }

    @Override
    public Optional<String> messageDeduplicationId() {
        return this.messageSystemAttribute(MessageSystemAttributeName.MESSAGE_DEDUPLICATION_ID).map(MessageSystemAttributeValue::stringValue);
    }

    @Override
    public Optional<String> messageGroupId() {
        return this.messageSystemAttribute(MessageSystemAttributeName.MESSAGE_GROUP_ID).map(MessageSystemAttributeValue::stringValue);
    }

    public void delete() {
        this.deleter.run();
    }

    public Runnable deleter() {
        return this.deleter;
    }

    public void changeVisibility(Duration timeout) {
        this.changeVisibility(timeout, false);
    }

    public void changeVisibility(Duration timeout, boolean stillInProcess) {
        this.visibilityChanger.execute(timeout, stillInProcess);
    }

    public SqsMessageVisibilityChanger visibilityChanger() {
        return this.visibilityChanger;
    }

    private static Map<String, MessageSystemAttributeValue> toMessageSystemAttributes(Map<String, String> messageSystemAttributesAsStrings) {
        return messageSystemAttributesAsStrings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> SqsReceiverMessage.toMessageSystemAttributeValue((String)entry.getValue())));
    }

    private static MessageSystemAttributeValue toMessageSystemAttributeValue(String value) {
        return (MessageSystemAttributeValue)MessageSystemAttributeValue.builder().stringValue(value).build();
    }
}

