/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.security.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import io.apiman.common.config.options.GenericOptionsParser;
import io.apiman.common.config.options.Predicates;
import io.apiman.manager.api.beans.idm.DiscoverabilityLevel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class DiscoverabilityOptionsParser
extends GenericOptionsParser {
    private final Map<String, RoleSourceDiscoverability> nameToDiscoverability = new HashMap<String, RoleSourceDiscoverability>();
    private final Multimap<Source, RoleSourceDiscoverability> sourceToDiscoverability = ArrayListMultimap.create();

    public DiscoverabilityOptionsParser(Map<String, String> options) {
        super(options);
        this.parseOptions();
    }

    private void parseOptions() {
        this.buildNameToDiscoverability();
        this.buildSourceToDiscoverability();
    }

    private void buildNameToDiscoverability() {
        this.getPrefix(this.options, 2).forEach((key, subMap) -> this.nameToDiscoverability.put((String)key, new DisConfigParser((String)key, (Map<String, String>)subMap).getRoleSourceDiscoverability()));
    }

    private void buildSourceToDiscoverability() {
        this.nameToDiscoverability.values().forEach(rsv -> this.sourceToDiscoverability.put((Object)rsv.getSource(), rsv));
    }

    private Map<String, Map<String, String>> getPrefix(Map<String, String> options, int lim) {
        return options.entrySet().stream().map(e -> this.splitEntry((Map.Entry<String, String>)e, lim)).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> {
            HashMap hm = new HashMap(e1);
            hm.putAll(e2);
            return hm;
        }));
    }

    private Map.Entry<String, Map<String, String>> splitEntry(Map.Entry<String, String> e, int lim) {
        String[] keySplit = e.getKey().split("\\.", lim);
        if (keySplit.length <= 1) {
            return null;
        }
        return Map.entry(keySplit[0], Map.of(keySplit[1], e.getValue()));
    }

    public Multimap<Source, RoleSourceDiscoverability> getSourceToDiscoverability() {
        return this.sourceToDiscoverability;
    }

    public Map<String, RoleSourceDiscoverability> getNameToDiscoverability() {
        return this.nameToDiscoverability;
    }

    public static enum Source {
        IDM_ROLE,
        IDM_ATTRIBUTE,
        APIMAN_ROLE,
        APIMAN_PERMISSION;


        public static Source toValue(String value) {
            return Enum.valueOf(Source.class, value.toUpperCase());
        }
    }

    public static final class RoleSourceDiscoverability {
        String name;
        Source source;
        Set<DiscoverabilityLevel> discoverabilities;

        public RoleSourceDiscoverability(String name, Source source, Set<DiscoverabilityLevel> discoverabilities) {
            this.name = name;
            this.source = source;
            this.discoverabilities = discoverabilities;
        }

        public String getName() {
            return this.name;
        }

        public Source getSource() {
            return this.source;
        }

        public void setSource(Source source) {
            this.source = source;
        }

        public Set<DiscoverabilityLevel> getDiscoverabilities() {
            return this.discoverabilities;
        }

        public void setDiscoverabilities(Set<DiscoverabilityLevel> discoverabilities) {
            this.discoverabilities = discoverabilities;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RoleSourceDiscoverability that = (RoleSourceDiscoverability)o;
            return this.source == that.source && Objects.equals(this.discoverabilities, that.discoverabilities);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.source, this.discoverabilities});
        }
    }

    private static final class DisConfigParser
    extends GenericOptionsParser {
        private RoleSourceDiscoverability roleSourceDiscoverability;
        private final String name;

        public DisConfigParser(String name, Map<String, String> opts) {
            super(opts);
            this.name = name;
            this.parseConfig();
        }

        public String getName() {
            return this.name;
        }

        public RoleSourceDiscoverability getRoleSourceDiscoverability() {
            return this.roleSourceDiscoverability;
        }

        private void parseConfig() {
            Source source = (Source)this.getRequiredEnum(DisConfigParser.keys((Object[])new String[]{"source"}), Source.class, Source::toValue);
            String discoverabilitiesJoined = this.getRequiredString(DisConfigParser.keys((Object[])new String[]{"discoverabilities"}), Predicates.anyOk(), "");
            Set<DiscoverabilityLevel> discoverabilities = Arrays.stream(DisConfigParser.split((String)discoverabilitiesJoined, (char)',')).map(DiscoverabilityLevel::toValue).collect(Collectors.toUnmodifiableSet());
            this.roleSourceDiscoverability = new RoleSourceDiscoverability(this.name, source, discoverabilities);
        }
    }
}

