/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.security;

import io.apiman.manager.api.beans.idm.DiscoverabilityLevel;
import io.apiman.manager.api.beans.idm.PermissionType;
import io.apiman.manager.api.beans.idm.UserDto;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public interface ISecurityContext {
    public String getCurrentUser();

    public String getFullName();

    public String getEmail();

    public boolean isAdmin();

    public boolean hasPermission(PermissionType var1, String var2);

    public boolean hasAllPermissions(Set<PermissionType> var1, String var2);

    public boolean hasAnyPermission(Set<PermissionType> var1, String var2);

    public boolean isMemberOf(String var1);

    public Set<String> getPermittedOrganizations(PermissionType var1);

    public Set<DiscoverabilityLevel> getPermittedDiscoverabilities();

    public String getRequestHeader(String var1);

    public void checkPermissions(PermissionType var1, String var2) throws NotAuthorizedException;

    public void checkAllPermissions(Set<PermissionType> var1, String var2) throws NotAuthorizedException;

    public void checkAnyPermission(Set<PermissionType> var1, String var2) throws NotAuthorizedException;

    public void checkAdminPermissions() throws NotAuthorizedException;

    public boolean hasPermissionsOrDiscoverable(EntityType var1, String var2, String var3, Set<PermissionType> var4);

    public boolean hasPermissionsOrDiscoverable(EntityType var1, String var2, String var3, String var4, Set<PermissionType> var5);

    public boolean isDiscoverable(EntityType var1, String var2, String var3);

    public boolean isDiscoverable(EntityType var1, String var2, String var3, String var4);

    public boolean isDiscoverable(EntityType var1, String var2, String var3, String var4, Set<DiscoverabilityLevel> var5);

    public void checkPermissionsOrDiscoverability(EntityType var1, String var2, String var3, Set<PermissionType> var4) throws NotAuthorizedException;

    public void checkPermissionsOrDiscoverability(EntityType var1, String var2, String var3, String var4, Set<PermissionType> var5) throws NotAuthorizedException;

    public void checkIfUserIsCurrentUser(String var1) throws NotAuthorizedException;

    public List<UserDto> getRemoteUsersWithRole(String var1);

    public List<UserDto> getUsersWithRole(String var1, String var2);

    public List<UserDto> getUsersWithPermission(PermissionType var1, String var2);

    public Locale getLocale();

    public static enum EntityType {
        API,
        PLAN;

    }
}

