/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.service;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.events.EventService;
import io.apiman.manager.api.exportimport.json.JsonImportReader;
import io.apiman.manager.api.exportimport.manager.StorageImportDispatcher;
import io.apiman.manager.api.exportimport.read.IImportReaderDispatcher;
import io.apiman.manager.api.migrator.DataMigrator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

@Transactional
@ApplicationScoped
public class ImportExportService {
    private final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(ImportExportService.class);
    private DataMigrator migrator;
    private StorageImportDispatcher importer;
    private EventService eventService;

    @Inject
    public ImportExportService(DataMigrator migrator, StorageImportDispatcher importer, EventService eventService) {
        this.migrator = migrator;
        this.importer = importer;
        this.eventService = eventService;
    }

    public ImportExportService() {
    }

    public void fullImport(File importFile, IApimanLogger logger) throws IOException {
        this.eventService.lock();
        try {
            this.eventService.deactivate();
            this.LOGGER.debug("Acquired exclusive lock on EventService and have deactivated event dispatch (all events will be dropped)");
            this.doImport(importFile, logger);
        }
        finally {
            this.eventService.activate();
            this.eventService.unlock();
            this.LOGGER.debug("Unlocked EventService and re-enabled event dispatch (events will now be sent)");
        }
    }

    private void doImport(File importFile, IApimanLogger logger) throws IOException {
        JsonImportReader reader;
        File migratedImportFile = File.createTempFile("apiman_import_migrated", ".json");
        migratedImportFile.deleteOnExit();
        this.migrator.migrate(importFile, migratedImportFile, logger);
        FileInputStream importData = null;
        try {
            importData = new FileInputStream(migratedImportFile);
            reader = new JsonImportReader(logger, (InputStream)importData);
        }
        catch (IOException e) {
            IOUtils.closeQuietly(importData);
            throw new UncheckedIOException(e);
        }
        try {
            this.importer.start(migratedImportFile.getAbsolutePath(), logger);
            reader.setDispatcher((IImportReaderDispatcher)this.importer);
            reader.read();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)importData);
            FileUtils.deleteQuietly((File)importFile);
            FileUtils.deleteQuietly((File)migratedImportFile);
        }
    }
}

