/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import com.google.common.collect.ImmutableList;
import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.beans.apis.ApiVersionBean;
import io.apiman.manager.api.beans.apis.dto.ApiVersionBeanDto;
import io.apiman.manager.api.beans.developers.DeveloperApiVersionBeanDto;
import io.apiman.manager.api.beans.developers.DeveloperBean;
import io.apiman.manager.api.beans.developers.DeveloperMapper;
import io.apiman.manager.api.beans.developers.DeveloperMappingBean;
import io.apiman.manager.api.beans.developers.UpdateDeveloperBean;
import io.apiman.manager.api.beans.summary.ClientVersionSummaryBean;
import io.apiman.manager.api.beans.summary.ContractSummaryBean;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.rest.IDeveloperResource;
import io.apiman.manager.api.rest.exceptions.DeveloperAlreadyExistsException;
import io.apiman.manager.api.rest.exceptions.DeveloperNotFoundException;
import io.apiman.manager.api.rest.exceptions.InvalidNameException;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.util.ExceptionFactory;
import io.apiman.manager.api.rest.impl.util.DataAccessUtilMixin;
import io.apiman.manager.api.rest.impl.util.RestHelper;
import io.apiman.manager.api.security.ISecurityContext;
import io.apiman.manager.api.service.ApiService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import javax.ws.rs.core.Response;

@Transactional
@ApplicationScoped
@Deprecated(forRemoval=true)
public class DeveloperResourceImpl
implements IDeveloperResource,
DataAccessUtilMixin {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(DeveloperResourceImpl.class);
    private IStorage storage;
    private IStorageQuery query;
    private ISecurityContext securityContext;
    private ApiService apiService;

    @Inject
    public DeveloperResourceImpl(IStorage storage, IStorageQuery query, ISecurityContext securityContext, ApiService apiService) {
        this.storage = storage;
        this.query = query;
        this.securityContext = securityContext;
        this.apiService = apiService;
    }

    public DeveloperResourceImpl() {
    }

    public List<ApiVersionBean> getAllPublicApiVersions() throws NotAuthorizedException {
        Iterator iterator = (Iterator)this.tryAction(() -> ((IStorage)this.storage).getAllPublicApiVersions());
        return ImmutableList.copyOf((Iterator)iterator);
    }

    public List<DeveloperBean> getDevelopers() throws NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        Iterator iterator = (Iterator)this.tryAction(() -> ((IStorage)this.storage).getDevelopers());
        return ImmutableList.copyOf((Iterator)iterator);
    }

    public DeveloperBean create(DeveloperBean bean) throws InvalidNameException, NotAuthorizedException, DeveloperAlreadyExistsException {
        this.securityContext.checkAdminPermissions();
        DeveloperBean developerBean = new DeveloperBean();
        developerBean.setId(bean.getId());
        developerBean.setClients(bean.getClients());
        return (DeveloperBean)this.tryAction(() -> {
            if (this.storage.getDeveloper(bean.getId()) != null) {
                throw ExceptionFactory.developerAlreadyExistsException((String)bean.getId());
            }
            this.storage.createDeveloper(developerBean);
            LOGGER.debug(String.format("Created developer %s: %s", developerBean.getId(), developerBean));
            return developerBean;
        });
    }

    public void update(String id, UpdateDeveloperBean bean) throws DeveloperNotFoundException, NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        this.tryAction(() -> {
            DeveloperBean developerBean = this.getDeveloperBeanFromStorage(id);
            developerBean.setClients(bean.getClients());
            this.storage.updateDeveloper(developerBean);
            LOGGER.debug(String.format("Updated developer %s: %s", developerBean.getId(), developerBean));
        });
    }

    public DeveloperBean get(String id) throws DeveloperNotFoundException, NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        return this.getDeveloperBeanFromStorage(id);
    }

    public void delete(String id) throws DeveloperNotFoundException, NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        DeveloperBean developerBean = this.getDeveloperBeanFromStorage(id);
        this.tryAction(() -> this.storage.deleteDeveloper(developerBean));
        LOGGER.debug("Deleted developer: {0}", new Object[]{developerBean.getId()});
    }

    public List<ClientVersionSummaryBean> getAllClientVersions(String id) throws DeveloperNotFoundException, NotAuthorizedException {
        this.securityContext.checkIfUserIsCurrentUser(id);
        DeveloperBean developer = this.getDeveloperBeanFromStorage(id);
        return this.queryMatchingClientVersions(developer);
    }

    public List<ContractSummaryBean> getAllClientContracts(String id) throws DeveloperNotFoundException, NotAuthorizedException {
        this.securityContext.checkIfUserIsCurrentUser(id);
        ArrayList<ContractSummaryBean> contractSummaryBeans = new ArrayList<ContractSummaryBean>();
        DeveloperBean developer = this.getDeveloperBeanFromStorage(id);
        List<ClientVersionSummaryBean> clientVersionSummaryBeans = this.queryMatchingClientVersions(developer);
        for (ClientVersionSummaryBean bean : clientVersionSummaryBeans) {
            List allClientContracts = (List)this.tryAction(() -> this.query.getClientContracts(bean.getOrganizationId(), bean.getId(), bean.getVersion()));
            contractSummaryBeans.addAll(allClientContracts);
        }
        return contractSummaryBeans;
    }

    public List<DeveloperApiVersionBeanDto> getAllApiVersions(String id) throws DeveloperNotFoundException, NotAuthorizedException {
        this.securityContext.checkIfUserIsCurrentUser(id);
        ArrayList<ApiVersionBeanDto> apiVersionBeans = new ArrayList<ApiVersionBeanDto>();
        List<ContractSummaryBean> contracts = this.getAllClientContracts(id);
        for (ContractSummaryBean contract : contracts) {
            ApiVersionBeanDto apiVersion = this.apiService.getApiVersion(contract.getApiOrganizationId(), contract.getApiId(), contract.getApiVersion());
            if (this.securityContext.isAdmin()) {
                apiVersionBeans.add(apiVersion);
                continue;
            }
            apiVersionBeans.add(RestHelper.hideSensitiveDataFromApiVersionBean(apiVersion));
        }
        return apiVersionBeans.stream().map(arg_0 -> ((DeveloperMapper)DeveloperMapper.INSTANCE).toDto(arg_0)).collect(Collectors.toList());
    }

    public Response getPublicApiDefinition(String organizationId, String apiId, String version) {
        ApiVersionBeanDto apiVersion = this.apiService.getApiVersion(organizationId, apiId, version);
        if (apiVersion.isPublicAPI()) {
            ApiService.ApiDefinitionStream apiDef = this.apiService.getApiDefinition(organizationId, apiId, version);
            return Response.ok().entity((Object)apiDef.getDefinition()).type(apiDef.getDefinitionType().getMediaType()).build();
        }
        throw ExceptionFactory.notAuthorizedException();
    }

    public Response getApiDefinition(String developerId, String organizationId, String apiId, String version) throws DeveloperNotFoundException, NotAuthorizedException {
        this.securityContext.checkIfUserIsCurrentUser(developerId);
        Set developerClients = this.getDeveloperBeanFromStorage(developerId).getClients();
        return (Response)this.tryAction(() -> {
            List contracts = this.query.getContracts(organizationId, apiId, version, 1, 10000);
            for (ContractSummaryBean contract : contracts) {
                for (DeveloperMappingBean client : developerClients) {
                    if (!client.getClientId().equals(contract.getClientId()) || !client.getOrganizationId().equals(contract.getClientOrganizationId())) continue;
                    ApiService.ApiDefinitionStream apiDef = this.apiService.getApiDefinition(organizationId, apiId, version);
                    return Response.ok().entity((Object)apiDef.getDefinition()).type(apiDef.getDefinitionType().getMediaType()).build();
                }
            }
            return Response.noContent();
        });
    }

    private DeveloperBean getDeveloperBeanFromStorage(String id) throws DeveloperNotFoundException {
        DeveloperBean developerBean = (DeveloperBean)this.tryAction(() -> this.storage.getDeveloper(id));
        if (developerBean == null) {
            throw ExceptionFactory.developerNotFoundException((String)id);
        }
        return developerBean;
    }

    private List<ClientVersionSummaryBean> queryMatchingClientVersions(DeveloperBean developer) {
        ArrayList<ClientVersionSummaryBean> clientVersionSummaryBeans = new ArrayList<ClientVersionSummaryBean>();
        Set developerMappingBeans = developer.getClients();
        for (DeveloperMappingBean bean : developerMappingBeans) {
            List allClientVersionsList = (List)this.tryAction(() -> this.query.getClientVersions(bean.getOrganizationId(), bean.getClientId()));
            clientVersionSummaryBeans.addAll(allClientVersionsList);
        }
        return clientVersionSummaryBeans;
    }
}

