/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.config.Version;
import io.apiman.manager.api.exportimport.manager.ExportImportManager;
import io.apiman.manager.api.providers.JacksonObjectMapperProvider;
import io.apiman.manager.api.rest.exceptions.mappers.BeanValidationExceptionMapper;
import io.apiman.manager.api.rest.exceptions.mappers.IllegalArgumentExceptionMapper;
import io.apiman.manager.api.rest.exceptions.mappers.RestExceptionMapper;
import io.apiman.manager.api.rest.impl.ActionResourceImpl;
import io.apiman.manager.api.rest.impl.BlobResourceImpl;
import io.apiman.manager.api.rest.impl.DeveloperPortalResourceImpl;
import io.apiman.manager.api.rest.impl.DeveloperResourceImpl;
import io.apiman.manager.api.rest.impl.DownloadResourceImpl;
import io.apiman.manager.api.rest.impl.EventResourceImpl;
import io.apiman.manager.api.rest.impl.GatewayResourceImpl;
import io.apiman.manager.api.rest.impl.OrganizationResourceImpl;
import io.apiman.manager.api.rest.impl.PluginResourceImpl;
import io.apiman.manager.api.rest.impl.PolicyDefinitionResourceImpl;
import io.apiman.manager.api.rest.impl.ProtectedDeveloperPortalResourceWrapper;
import io.apiman.manager.api.rest.impl.RoleResourceImpl;
import io.apiman.manager.api.rest.impl.SearchResourceImpl;
import io.apiman.manager.api.rest.impl.SystemResourceImpl;
import io.apiman.manager.api.rest.impl.UserResourceImpl;
import io.apiman.manager.api.rest.interceptors.BlobResourceInterceptorProvider;
import io.apiman.manager.api.rest.interceptors.TotalCountInterceptorProvider;
import io.swagger.v3.jaxrs2.integration.JaxrsOpenApiContextBuilder;
import io.swagger.v3.jaxrs2.integration.resources.OpenApiResource;
import io.swagger.v3.oas.integration.OpenApiConfigurationException;
import io.swagger.v3.oas.integration.SwaggerConfiguration;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.servers.Server;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@ApplicationPath(value="/")
@ApplicationScoped
public class ApiManagerApplication
extends Application {
    private IApimanLogger log = ApimanLoggerFactory.getLogger(ApiManagerApplication.class);
    @Inject
    private ExportImportManager manager;
    private Set<Class<?>> classes = new HashSet();
    private static final Set<String> klazzes = new LinkedHashSet<String>();

    public ApiManagerApplication() {
        this.classes.add(SystemResourceImpl.class);
        this.classes.add(SearchResourceImpl.class);
        this.classes.add(RoleResourceImpl.class);
        this.classes.add(UserResourceImpl.class);
        this.classes.add(OrganizationResourceImpl.class);
        this.classes.add(PolicyDefinitionResourceImpl.class);
        this.classes.add(GatewayResourceImpl.class);
        this.classes.add(PluginResourceImpl.class);
        this.classes.add(ActionResourceImpl.class);
        this.classes.add(DownloadResourceImpl.class);
        this.classes.add(DeveloperResourceImpl.class);
        this.classes.add(BlobResourceImpl.class);
        this.classes.add(EventResourceImpl.class);
        this.classes.add(DeveloperPortalResourceImpl.class);
        this.classes.add(ProtectedDeveloperPortalResourceWrapper.class);
        this.classes.add(OpenApiResource.class);
        this.classes.add(RestExceptionMapper.class);
        this.classes.add(IllegalArgumentExceptionMapper.class);
        this.classes.add(BeanValidationExceptionMapper.class);
        this.registerProviders(JacksonObjectMapperProvider.class, BlobResourceInterceptorProvider.class, TotalCountInterceptorProvider.class, RestExceptionMapper.class);
        OpenAPI oas = new OpenAPI();
        oas.setInfo(new Info().title("API Manager REST API").version(new Version().getVersionString()).description("The API Manager REST API is used by the API Manager UI to get stuff done. You can use it to automate any API Management task you wish. For example, create new Organizations, Plans, Clients, and APIs."));
        oas.addServersItem(new Server().url(this.getBasePath()));
        SwaggerConfiguration oasConfig = new SwaggerConfiguration().openAPI(oas).resourcePackages(Set.of("io.apiman.manager.api.rest")).resourceClasses(klazzes).prettyPrint(Boolean.valueOf(true));
        try {
            new JaxrsOpenApiContextBuilder().application((Application)this).openApiConfiguration((OpenAPIConfiguration)oasConfig).resourcePackages(Set.of("io.apiman.manager.api.rest")).resourceClasses(klazzes).buildContext(true);
        }
        catch (OpenApiConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void registerProviders(Class<?> ... classes) {
        for (Class<?> klazz : classes) {
            this.log.info("Registering provider: {0}", new Object[]{klazz.getCanonicalName()});
            ResteasyProviderFactory.getInstance().register(klazz);
            klazzes.add(klazz.getCanonicalName());
        }
    }

    @PostConstruct
    protected void postConstruct() {
        if (this.manager.isImportExport()) {
            this.manager.doImportExport();
        }
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    private String getBasePath() {
        String basePath = "/apiman";
        String prefix = System.getenv("SYSTEM_PREFIX");
        return prefix == null ? basePath : prefix.trim().toLowerCase() + basePath;
    }
}

