/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.notifications.producers;

import io.apiman.manager.api.beans.events.AccountSignupEvent;
import io.apiman.manager.api.beans.events.IVersionedApimanEvent;
import io.apiman.manager.api.beans.notifications.NotificationCategory;
import io.apiman.manager.api.beans.notifications.dto.CreateNotificationDto;
import io.apiman.manager.api.beans.notifications.dto.RecipientDto;
import io.apiman.manager.api.beans.notifications.dto.RecipientType;
import io.apiman.manager.api.notifications.INotificationProducer;
import io.apiman.manager.api.service.NotificationService;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;

@ApplicationScoped
public class NewAccountNotificationProducer
implements INotificationProducer {
    public static final String APIMAN_ACCOUNT_APPROVAL_REQUEST = "apiman.account.approval.request";
    private final NotificationService notificationService;

    @Inject
    public NewAccountNotificationProducer(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void processEvent(@Observes AccountSignupEvent signupEvent) {
        if (signupEvent.isApprovalRequired()) {
            CreateNotificationDto newNotification = new CreateNotificationDto();
            RecipientDto approversRole = new RecipientDto().setRecipient("approver").setRecipientType(RecipientType.ROLE);
            newNotification.setRecipient(List.of(approversRole)).setReason(APIMAN_ACCOUNT_APPROVAL_REQUEST).setReasonMessage("A new account needs approval to gain access " + signupEvent.getUsername()).setCategory(NotificationCategory.USER_ADMINISTRATION).setSource("/apiman/notifications/account/approvals").setPayload((IVersionedApimanEvent)signupEvent);
            this.notificationService.sendNotification(newNotification);
        }
    }
}

