/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.events;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.common.util.JsonUtil;
import io.apiman.manager.api.beans.events.ApimanEvent;
import io.apiman.manager.api.beans.events.IVersionedApimanEvent;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.util.NoSuchElementException;
import java.util.StringJoiner;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;

@ApplicationScoped
public class EventFactory {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(EventFactory.class);
    private final Multimap<String, ClazzAndMetadata> klazzez = ArrayListMultimap.create();

    @Inject
    public EventFactory() {
    }

    @PostConstruct
    public void postConstruct() {
        this.findEvents();
    }

    private void findEvents() {
        try (ScanResult scanResult = new ClassGraph().enableAnnotationInfo().enableClassInfo().acceptPackages(new String[]{"io.apiman.manager.api"}).scan();){
            for (ClassInfo klazzInfo : scanResult.getClassesImplementing(IVersionedApimanEvent.class)) {
                try {
                    Class klazz = klazzInfo.loadClass();
                    String name = this.calculateName(klazz);
                    ApimanEvent metadata = this.getAnnotation(klazz);
                    this.klazzez.put((Object)name, (Object)new ClazzAndMetadata(metadata, klazz));
                    LOGGER.debug("Calculated name for {0} as {1}", new Object[]{klazz, name});
                }
                catch (Throwable t) {
                    LOGGER.warn("Ignoring exception during event class load: {0}", new Object[]{t});
                }
            }
        }
    }

    private ApimanEvent getAnnotation(Class<? extends IVersionedApimanEvent> klazz) {
        if (klazz.isAnnotationPresent(ApimanEvent.class)) {
            return klazz.getAnnotation(ApimanEvent.class);
        }
        return null;
    }

    private String calculateName(Class<? extends IVersionedApimanEvent> klazz) {
        if (klazz.isAnnotationPresent(ApimanEvent.class)) {
            ApimanEvent anno = klazz.getAnnotation(ApimanEvent.class);
            LOGGER.debug("Found annotation {0} for {1}", new Object[]{anno, klazz.getCanonicalName()});
            if (!"".equals(anno.name())) {
                return anno.name();
            }
            return klazz.getCanonicalName();
        }
        return klazz.getCanonicalName();
    }

    public <E extends IVersionedApimanEvent> E toEventPojo(JsonNode payload) {
        return (E)((IVersionedApimanEvent)JsonUtil.toPojo((JsonNode)payload, this.getKlazz(payload)));
    }

    public Class<? extends IVersionedApimanEvent> getKlazz(JsonNode payload) {
        JsonNode possibleHeaders = payload.at("/headers");
        if (!possibleHeaders.isMissingNode() && possibleHeaders.isObject()) {
            String type = possibleHeaders.get("type").asText();
            long version = possibleHeaders.get("eventVersion").asLong();
            if (StringUtils.isBlank((CharSequence)type)) {
                throw new IllegalStateException("'type' field missing from headers");
            }
            ClazzAndMetadata result = this.klazzez.get((Object)type).stream().filter(k -> k.metadata.version() == version).findFirst().orElseThrow(() -> new NoSuchElementException("Can't find an event class for " + payload));
            LOGGER.debug("Found class for event payload: {0}", new Object[]{result});
            return result.klazz;
        }
        throw new IllegalArgumentException("Provided JsonNode structure does not appear to be an ApimanEvent: " + payload);
    }

    private static final class ClazzAndMetadata {
        private final ApimanEvent metadata;
        private final Class<? extends IVersionedApimanEvent> klazz;

        public ClazzAndMetadata(ApimanEvent metadata, Class<? extends IVersionedApimanEvent> klazz) {
            this.metadata = metadata;
            this.klazz = klazz;
        }

        public String toString() {
            return new StringJoiner(", ", ClazzAndMetadata.class.getSimpleName() + "[", "]").add("metadata=" + this.metadata).add("klazz=" + this.klazz).toString();
        }
    }
}

