/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.var;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.Run;
import io.alauda.jenkins.devops.sync.WorkflowJobProperty;
import io.alauda.jenkins.devops.sync.var.AlaudaContext;
import java.util.Map;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jenkinsci.plugins.workflow.cps.GlobalVariable;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

@Extension
public class AlaudaGlobalVariable
extends GlobalVariable {
    @Nonnull
    public String getName() {
        return "alaudaContext";
    }

    @Nonnull
    public Object getValue(@Nonnull CpsScript script) throws Exception {
        Run build = script.$build();
        if (build == null) {
            throw new IllegalStateException("cannot find owning build");
        }
        Job parent = build.getParent();
        if (parent instanceof WorkflowJob) {
            WorkflowJobProperty property = (WorkflowJobProperty)parent.getProperty(WorkflowJobProperty.class);
            if (property == null) {
                return new AlaudaContext("", "", null, false);
            }
            String namespace = property.getNamespace();
            String name = property.getName();
            String contextannotation = property.getContextAnnotation();
            JSONObject data = null;
            if (contextannotation != null) {
                data = JSONObject.fromObject((Object)contextannotation);
            }
            return new AlaudaContext(name, namespace, (Map)data, true);
        }
        throw new IllegalStateException("not intance of WorkflowJob");
    }
}

