/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.util;

import antlr.ANTLRException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.BooleanParameterDefinition;
import hudson.model.BooleanParameterValue;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.StringParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.model.TopLevelItem;
import hudson.model.queue.QueueTaskFuture;
import hudson.plugins.git.RevisionParameterAction;
import hudson.remoting.Callable;
import hudson.security.ACL;
import hudson.triggers.SCMTrigger;
import hudson.triggers.SafeTimerTask;
import hudson.triggers.TimerTrigger;
import io.alauda.devops.java.client.models.V1alpha1Pipeline;
import io.alauda.devops.java.client.models.V1alpha1PipelineBuilder;
import io.alauda.devops.java.client.models.V1alpha1PipelineConfig;
import io.alauda.devops.java.client.models.V1alpha1PipelineParameter;
import io.alauda.devops.java.client.models.V1alpha1PipelineSourceGit;
import io.alauda.devops.java.client.models.V1alpha1PipelineTrigger;
import io.alauda.devops.java.client.models.V1alpha1PipelineTriggerCodeChange;
import io.alauda.devops.java.client.models.V1alpha1PipelineTriggerCron;
import io.alauda.jenkins.devops.sync.AlaudaJobProperty;
import io.alauda.jenkins.devops.sync.JenkinsPipelineCause;
import io.alauda.jenkins.devops.sync.MultiBranchProperty;
import io.alauda.jenkins.devops.sync.SCMRevisionAction;
import io.alauda.jenkins.devops.sync.WorkflowJobProperty;
import io.alauda.jenkins.devops.sync.action.AlaudaQueueAction;
import io.alauda.jenkins.devops.sync.client.Clients;
import io.alauda.jenkins.devops.sync.util.AlaudaUtils;
import io.alauda.jenkins.devops.sync.util.CollectionUtils;
import io.alauda.jenkins.devops.sync.util.PipelineToActionMapper;
import io.alauda.jenkins.devops.sync.util.PipelineUtils;
import io.kubernetes.client.models.V1ObjectMeta;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.MultiBranchProject;
import jenkins.model.Jenkins;
import jenkins.security.NotReallyRoleSensitiveCallable;
import jenkins.util.Timer;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTPipelineDef;
import org.jenkinsci.plugins.pipeline.modeldefinition.parser.Converter;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.job.properties.PipelineTriggersJobProperty;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;

public abstract class JenkinsUtils {
    private static final Logger LOGGER = Logger.getLogger(JenkinsUtils.class.getName());
    public static final String PARAM_FROM_ENV_DESCRIPTION = "From Alauda DevOps PipelineConfig Parameter";

    private JenkinsUtils() {
    }

    public static Job getJob(String job) {
        TopLevelItem item = Jenkins.getInstance().getItem(job);
        if (item instanceof Job) {
            return (Job)item;
        }
        return null;
    }

    @NotNull
    public static String getRootUrl() {
        String root = Jenkins.getInstance().getRootUrl();
        return StringUtils.isBlank((String)root) ? "http://localhost:8080/" : root;
    }

    public static boolean verifyEnvVars(Map<String, ParameterDefinition> paramMap, WorkflowJob workflowJob) {
        if (paramMap != null) {
            String fullName = workflowJob.getFullName();
            WorkflowJob job = (WorkflowJob)Jenkins.getInstance().getItemByFullName(fullName, WorkflowJob.class);
            if (job == null) {
                LOGGER.warning(() -> "A run of workflow job " + workflowJob.getName() + " unexpectantly not saved to disk.");
                return false;
            }
            ParametersDefinitionProperty props = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
            List names = props.getParameterDefinitionNames();
            for (String name : names) {
                if (paramMap.containsKey(name)) continue;
                LOGGER.warning(() -> "A run of workflow job " + job.getName() + " was expecting parameter " + name + ", but it is not in the parameter list");
                return false;
            }
        }
        return true;
    }

    public static Map<String, ParameterDefinition> addJobParamForPipelineParameters(WorkflowJob job, List<V1alpha1PipelineParameter> params, boolean replaceExisting) throws IOException {
        ParametersDefinitionProperty jenkinsParams = (ParametersDefinitionProperty)job.removeProperty(ParametersDefinitionProperty.class);
        HashMap<String, Object> paramMap = null;
        if (params != null && params.size() > 0) {
            ArrayList<String> envKeys = new ArrayList<String>();
            for (V1alpha1PipelineParameter v1alpha1PipelineParameter : params) {
                envKeys.add(v1alpha1PipelineParameter.getName());
            }
            paramMap = new HashMap<String, Object>();
            if (jenkinsParams != null) {
                List existingParamList = jenkinsParams.getParameterDefinitions();
                Iterator iterator = existingParamList.iterator();
                while (iterator.hasNext()) {
                    ParameterDefinition param = (ParameterDefinition)iterator.next();
                    if (param.getDescription() == null || !param.getDescription().equals(PARAM_FROM_ENV_DESCRIPTION)) {
                        paramMap.put(param.getName(), param);
                        continue;
                    }
                    if (!envKeys.contains(param.getName())) continue;
                    paramMap.put(param.getName(), param);
                }
            }
            for (V1alpha1PipelineParameter v1alpha1PipelineParameter : params) {
                StringParameterDefinition jenkinsParam = null;
                switch (v1alpha1PipelineParameter.getType()) {
                    case "StringParameterDefinition": 
                    case "string": {
                        jenkinsParam = new StringParameterDefinition(v1alpha1PipelineParameter.getName(), v1alpha1PipelineParameter.getValue(), v1alpha1PipelineParameter.getDescription());
                        break;
                    }
                    case "BooleanParameterDefinition": 
                    case "boolean": {
                        jenkinsParam = new BooleanParameterDefinition(v1alpha1PipelineParameter.getName(), Boolean.valueOf(v1alpha1PipelineParameter.getValue()).booleanValue(), v1alpha1PipelineParameter.getDescription());
                        break;
                    }
                    default: {
                        LOGGER.warning(() -> "Parameter type `" + param.getType() + "` is not supported.. skipping...");
                    }
                }
                if (jenkinsParam == null || !replaceExisting && paramMap.containsKey(jenkinsParam.getName())) continue;
                paramMap.put(jenkinsParam.getName(), jenkinsParam);
            }
            ArrayList newParamList = new ArrayList(paramMap.values());
            job.addProperty((JobProperty)new ParametersDefinitionProperty(newParamList));
        }
        job.save();
        return paramMap;
    }

    @NotNull
    public static List<ANTLRException> setJobTriggers(@Nonnull WorkflowJob job, List<V1alpha1PipelineTrigger> triggers) throws IOException {
        ArrayList<ANTLRException> exceptions = new ArrayList<ANTLRException>();
        if (CollectionUtils.isEmpty(triggers)) {
            return exceptions;
        }
        job.removeProperty(PipelineTriggersJobProperty.class);
        LOGGER.info(() -> "PipelineTrigger's count is " + triggers.size());
        for (V1alpha1PipelineTrigger pipelineTrigger : triggers) {
            SCMTrigger trigger = null;
            String type = pipelineTrigger.getType();
            if (type == null) continue;
            switch (type) {
                case "codeChange": {
                    V1alpha1PipelineTriggerCodeChange codeTrigger = pipelineTrigger.getCodeChange();
                    if (codeTrigger == null || !codeTrigger.isEnabled().booleanValue()) {
                        LOGGER.warning(() -> "Trigger type `codeChange` has empty description or is disabled...");
                        break;
                    }
                    try {
                        trigger = new SCMTrigger(codeTrigger.getPeriodicCheck());
                        LOGGER.info(() -> "Add CodeChangeTrigger.");
                    }
                    catch (ANTLRException exc) {
                        LOGGER.log(Level.SEVERE, String.format("Error processing trigger type %s", "codeChange"), exc);
                        exceptions.add(exc);
                    }
                    break;
                }
                case "cron": {
                    V1alpha1PipelineTriggerCron cronTrigger = pipelineTrigger.getCron();
                    if (cronTrigger == null || !cronTrigger.isEnabled().booleanValue()) {
                        LOGGER.warning(() -> "Trigger type `cron` has empty description or is disabled...");
                        break;
                    }
                    try {
                        trigger = new TimerTrigger(cronTrigger.getRule());
                        LOGGER.info(() -> "Add CronTrigger.");
                    }
                    catch (ANTLRException exc) {
                        LOGGER.log(Level.SEVERE, String.format("Error processing trigger type %s", "cron"), exc);
                        exceptions.add(exc);
                    }
                    break;
                }
                default: {
                    LOGGER.warning(() -> "Trigger type `" + pipelineTrigger.getType() + "` is not supported... skipping...");
                }
            }
            if (trigger == null) continue;
            job.addTrigger(trigger);
        }
        LOGGER.info(() -> "Job trigger save done.");
        return exceptions;
    }

    @CheckForNull
    private static List<Action> putJobRunParamsFromEnvAndUIParams(List<V1alpha1PipelineParameter> pipelineParameters, List<Action> buildActions) {
        if (buildActions == null || pipelineParameters == null) {
            return buildActions;
        }
        List<ParameterValue> envVarList = JenkinsUtils.getParameterValues(pipelineParameters);
        if (envVarList.size() == 0) {
            return buildActions;
        }
        buildActions.add((Action)new ParametersAction(envVarList));
        return buildActions;
    }

    @Nonnull
    private static List<ParameterValue> getParameterValues(List<V1alpha1PipelineParameter> pipelineParameters) {
        ArrayList<ParameterValue> envVarList = new ArrayList<ParameterValue>();
        if (pipelineParameters == null) {
            return envVarList;
        }
        for (V1alpha1PipelineParameter pipeParam : pipelineParameters) {
            StringParameterValue paramValue = null;
            String type = pipeParam.getType();
            if (type == null) continue;
            switch (type) {
                case "StringParameterDefinition": 
                case "string": {
                    paramValue = new StringParameterValue(pipeParam.getName(), pipeParam.getValue(), pipeParam.getDescription());
                    break;
                }
                case "BooleanParameterDefinition": 
                case "boolean": {
                    paramValue = new BooleanParameterValue(pipeParam.getName(), Boolean.valueOf(pipeParam.getValue()).booleanValue(), pipeParam.getDescription());
                    break;
                }
                default: {
                    LOGGER.warning(() -> "Parameter type `" + pipeParam.getType() + "` is not supported.. skipping...");
                }
            }
            if (paramValue == null) continue;
            envVarList.add((ParameterValue)paramValue);
        }
        return envVarList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean triggerJob(@Nonnull WorkflowJob job, @Nonnull V1alpha1Pipeline pipeline) throws IOException {
        V1ObjectMeta pipMeta = pipeline.getMetadata();
        String namespace = pipMeta.getNamespace();
        String pipelineName = pipMeta.getName();
        LOGGER.info(() -> "will trigger pipeline: " + pipelineName);
        if (JenkinsUtils.isAlreadyTriggered(job, pipeline)) {
            LOGGER.info(() -> "pipeline already triggered: " + pipelineName);
            return false;
        }
        AlaudaJobProperty pcProp = (AlaudaJobProperty)job.getProperty(WorkflowJobProperty.class);
        if (pcProp == null && job.getParent() instanceof WorkflowMultiBranchProject) {
            pcProp = (AlaudaJobProperty)((WorkflowMultiBranchProject)job.getParent()).getProperties().get(MultiBranchProperty.class);
        }
        if (pcProp == null) {
            LOGGER.warning(() -> "aborting trigger of pipeline " + pipeline.getMetadata().getNamespace() + "/" + pipeline.getMetadata().getName() + "because of missing pc project property");
            return false;
        }
        String pipelineConfigName = pipeline.getSpec().getPipelineConfig().getName();
        V1alpha1PipelineConfig pipelineConfig = (V1alpha1PipelineConfig)Clients.get(V1alpha1PipelineConfig.class).lister().namespace(namespace).get(pipelineConfigName);
        if (pipelineConfig == null) {
            LOGGER.info(() -> "pipeline config not found....: " + pipelineName + " - config name " + pipelineConfigName);
            return false;
        }
        String string = pipelineConfig.getMetadata().getUid().intern();
        synchronized (string) {
            LOGGER.info(() -> "pipeline config source credentials: " + pipelineConfig.getMetadata().getName());
            ArrayList<JenkinsPipelineCause> newCauses = new ArrayList<JenkinsPipelineCause>();
            newCauses.add(new JenkinsPipelineCause(pipeline, pcProp.getUid()));
            CauseAction originalCauseAction = PipelineToActionMapper.removeCauseAction(pipelineName);
            if (originalCauseAction != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Adding existing causes...");
                    for (Cause cause : originalCauseAction.getCauses()) {
                        LOGGER.log(Level.FINE, "trigger error", cause);
                    }
                }
                newCauses.addAll(originalCauseAction.getCauses());
                if (LOGGER.isLoggable(Level.FINE)) {
                    for (Cause cause : newCauses) {
                        LOGGER.log(Level.FINE, "trigger error", cause);
                    }
                }
            }
            ArrayList<Action> pipelineActions = new ArrayList<Action>();
            CauseAction causeAction = new CauseAction(newCauses);
            pipelineActions.add((Action)causeAction);
            pipelineActions.add((Action)new AlaudaQueueAction());
            V1alpha1PipelineSourceGit sourceGit = pipeline.getSpec().getSource().getGit();
            String commit = null;
            if (pipMeta.getAnnotations() != null && pipMeta.getAnnotations().containsKey("alauda.io/commit")) {
                commit = (String)pipMeta.getAnnotations().get("alauda.io/commit");
            }
            if (sourceGit != null && commit != null) {
                try {
                    URIish repoURL = new URIish(sourceGit.getUri());
                    pipelineActions.add((Action)new RevisionParameterAction(commit, repoURL));
                }
                catch (URISyntaxException e) {
                    LOGGER.log(Level.SEVERE, "Failed to parse git repo URL" + sourceGit.getUri(), e);
                }
            }
            LOGGER.info("pipeline got cause....: " + pipelineName + " pipeline actions " + pipelineActions);
            PipelineToActionMapper.removeParameterAction(pipelineName);
            JenkinsUtils.putJobRunParamsFromEnvAndUIParams(pipeline.getSpec().getParameters(), pipelineActions);
            LOGGER.info(() -> "pipeline config update with job: " + pipelineName + " pipeline config " + pipelineConfig.getMetadata().getName());
            Action[] actionArray = pipelineActions.size() == 0 ? new Action[]{} : pipelineActions.toArray(new Action[0]);
            QueueTaskFuture queueTaskFuture = job.scheduleBuild2(0, actionArray);
            if (queueTaskFuture != null) {
                if (job.getParent() instanceof MultiBranchProject) {
                    BranchProjectFactory factory = ((MultiBranchProject)job.getParent()).getProjectFactory();
                    SCMRevisionAction revisionAction = null;
                    block9: for (Action action : actionArray) {
                        List causes;
                        if (!(action instanceof CauseAction) || (causes = ((CauseAction)action).getCauses()) == null) continue;
                        for (Cause cause : causes) {
                            if (!(cause instanceof SCMRevisionAction)) continue;
                            revisionAction = (SCMRevisionAction)cause;
                            continue block9;
                        }
                    }
                    if (revisionAction != null) {
                        factory.setRevisionHash((Job)job, revisionAction.getRevision());
                    }
                }
                pipeline.getStatus().setPhase("Queued");
                try {
                    TimeUnit.MILLISECONDS.sleep(50L);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.SEVERE, "updatePipelinePhase Interrupted", e);
                    Thread.currentThread().interrupt();
                }
                return true;
            }
            pipeline.getStatus().setPhase("Failed");
            LOGGER.info(() -> "Will not schedule build for this pipeline: " + pipelineName);
            return false;
        }
    }

    private static boolean isAlreadyTriggered(WorkflowJob job, V1alpha1Pipeline pipeline) {
        return JenkinsUtils.getRun(job, pipeline) != null;
    }

    public static synchronized void cancelPipeline(WorkflowJob job, V1alpha1Pipeline pipeline) {
        JenkinsUtils.cancelPipeline(job, pipeline, false);
    }

    public static synchronized void cancelPipeline(WorkflowJob job, V1alpha1Pipeline pipeline, boolean deleted) {
        if (!JenkinsUtils.cancelQueuedPipeline(job, pipeline)) {
            JenkinsUtils.cancelRunningPipeline(job, pipeline);
        }
        if (deleted) {
            return;
        }
        AlaudaUtils.updatePipelinePhase(pipeline, "Cancelled");
    }

    private static WorkflowRun getRun(WorkflowJob job, V1alpha1Pipeline pipeline) {
        if (pipeline != null && pipeline.getMetadata() != null) {
            return JenkinsUtils.getRun(job, pipeline.getMetadata().getUid());
        }
        return null;
    }

    private static WorkflowRun getRun(WorkflowJob job, String pipelineUid) {
        for (WorkflowRun run : job.getBuilds()) {
            JenkinsPipelineCause cause = PipelineUtils.findAlaudaCause((Actionable)run);
            if (cause == null || !cause.getUid().equals(pipelineUid)) continue;
            return run;
        }
        return null;
    }

    public static synchronized void deleteRun(WorkflowRun run) {
        try {
            LOGGER.info("Deleting run: " + run.toString());
            run.delete();
        }
        catch (IOException e) {
            LOGGER.warning(() -> "Unable to delete run " + run.toString() + ":" + e.getMessage());
        }
    }

    private static boolean cancelRunningPipeline(WorkflowJob job, V1alpha1Pipeline pipeline) {
        String pipelineUid = pipeline.getMetadata().getUid();
        WorkflowRun run = JenkinsUtils.getRun(job, pipelineUid);
        if (run != null && run.isBuilding()) {
            JenkinsUtils.terminateRun(run);
            return true;
        }
        return false;
    }

    private static boolean cancelNotYetStartedPipeline(WorkflowJob job, V1alpha1Pipeline pipeline) {
        String pipelineUid = pipeline.getMetadata().getUid();
        WorkflowRun run = JenkinsUtils.getRun(job, pipelineUid);
        if (run != null && run.hasntStartedYet()) {
            JenkinsUtils.terminateRun(run);
            return true;
        }
        return false;
    }

    public static void terminateRun(final WorkflowRun run) {
        ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, RuntimeException>(){

            public Void call() throws RuntimeException {
                run.doTerm();
                Timer.get().schedule((Runnable)new SafeTimerTask(){

                    public void doRun() {
                        ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, RuntimeException>(){

                            public Void call() throws RuntimeException {
                                run.doKill();
                                return null;
                            }
                        });
                    }
                }, 5L, TimeUnit.SECONDS);
                return null;
            }
        });
    }

    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private static boolean cancelQueuedPipeline(WorkflowJob job, V1alpha1Pipeline pipeline) {
        LOGGER.info("cancelling queued pipeline: " + pipeline.getMetadata().getName());
        String pipelineUid = pipeline.getMetadata().getUid();
        final Queue pipelineQueue = Jenkins.getInstance().getQueue();
        boolean foundInQueue = false;
        for (final Queue.Item item : pipelineQueue.getItems()) {
            for (JenkinsPipelineCause cause : PipelineUtils.findAllAlaudaCauses((Actionable)item)) {
                if (!cause.getUid().equals(pipelineUid)) continue;
                foundInQueue = true;
                return (Boolean)ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Boolean, RuntimeException>(){

                    public Boolean call() throws RuntimeException {
                        pipelineQueue.cancel(item);
                        return true;
                    }
                });
            }
        }
        if (!foundInQueue) {
            LOGGER.info("Not found pipeline: %s" + pipeline.getMetadata().getName());
        }
        return JenkinsUtils.cancelNotYetStartedPipeline(job, pipeline);
    }

    public static void cancelQueuedBuilds(WorkflowJob job, String pcUid) {
        LOGGER.info(() -> "cancelling queued pipeline by uuid: " + pcUid);
        Queue pipelineQueue = Jenkins.getInstance().getQueue();
        for (Queue.Item item : pipelineQueue.getItems()) {
            JenkinsPipelineCause pipelineCause = PipelineUtils.findAlaudaCause((Actionable)item);
            if (pipelineCause == null || !pipelineCause.getPipelineConfigUid().equals(pcUid)) continue;
            V1alpha1Pipeline pipeline = ((V1alpha1PipelineBuilder)new V1alpha1PipelineBuilder().withMetadata(new V1ObjectMeta().namespace(pipelineCause.getNamespace()).name(pipelineCause.getName()))).build();
            JenkinsUtils.cancelQueuedPipeline(job, pipeline);
        }
    }

    @Nonnull
    public static String getFullJobName(@Nonnull WorkflowJob job) {
        return job.getRelativeNameFrom((ItemGroup)Jenkins.getInstance());
    }

    @Nonnull
    public static String formatJenkinsfile(String unformattedJenkinsfile) throws IOException {
        ModelASTPipelineDef pipelineDef = Converter.scriptToPipelineDef((String)unformattedJenkinsfile);
        if (pipelineDef == null) {
            throw new IOException("Jenkinsfile content '" + unformattedJenkinsfile + "' did not contain the 'pipeline' step or miss some steps");
        }
        return pipelineDef.toPrettyGroovy();
    }

    public static boolean fromMultiBranch(@NotNull Run run) {
        Job wfJob = run.getParent();
        if (!(wfJob instanceof WorkflowJob)) {
            return false;
        }
        return wfJob.getParent() instanceof WorkflowMultiBranchProject;
    }
}

