/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.mapper.converter;

import antlr.ANTLRException;
import com.cloudbees.hudson.plugins.folder.Folder;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.JobProperty;
import io.alauda.devops.java.client.models.V1alpha1PipelineConfig;
import io.alauda.jenkins.devops.sync.PipelineConfigProjectProperty;
import io.alauda.jenkins.devops.sync.PipelineConfigToJobMapper;
import io.alauda.jenkins.devops.sync.WorkflowJobProperty;
import io.alauda.jenkins.devops.sync.client.JenkinsClient;
import io.alauda.jenkins.devops.sync.exception.PipelineConfigConvertException;
import io.alauda.jenkins.devops.sync.mapper.PipelineConfigMapper;
import io.alauda.jenkins.devops.sync.mapper.converter.JobConverter;
import io.alauda.jenkins.devops.sync.util.JenkinsUtils;
import io.alauda.jenkins.devops.sync.util.NamespaceName;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class WorkflowJobConverter
implements JobConverter<WorkflowJob> {
    private Logger logger = LoggerFactory.getLogger((String)WorkflowJobConverter.class.getName());
    private PipelineConfigMapper mapper = new PipelineConfigMapper();
    private JenkinsClient jenkinsClient = JenkinsClient.getInstance();

    @Override
    public boolean accept(V1alpha1PipelineConfig pipelineConfig) {
        if (pipelineConfig == null) {
            return false;
        }
        Map labels = pipelineConfig.getMetadata().getLabels();
        return labels == null || !"multi-branch".equals(labels.get("pipeline.kind"));
    }

    @Override
    public WorkflowJob convert(V1alpha1PipelineConfig pipelineConfig) throws PipelineConfigConvertException, IOException {
        WorkflowJob job;
        String name;
        String namespace = pipelineConfig.getMetadata().getNamespace();
        NamespaceName namespaceName = new NamespaceName(namespace, name = pipelineConfig.getMetadata().getName());
        Item item = this.jenkinsClient.getItem(namespaceName);
        if (item == null) {
            this.logger.debug("Unable to found a Jenkins job for PipelineConfig '{}/{}'", (Object)namespace, (Object)name);
            Folder parentFolder = this.jenkinsClient.upsertFolder(namespace);
            job = new WorkflowJob((ItemGroup)parentFolder, this.mapper.jenkinsJobName(namespace, name));
            job.addProperty((JobProperty)WorkflowJobProperty.getInstance(pipelineConfig));
        } else {
            if (!(item instanceof WorkflowJob)) {
                throw new PipelineConfigConvertException(new String[]{String.format("Unable to update Jenkins job, except a WorkflowJob but found a %s", item.getClass())});
            }
            job = (WorkflowJob)item;
            WorkflowJobProperty wfJobProperty = (WorkflowJobProperty)job.getProperty(WorkflowJobProperty.class);
            if (wfJobProperty == null) {
                this.logger.warn("Missing the AlaudaWorkflowJobProperty for PipelineConfig '{}/{}', try to find a old property.", (Object)namespace, (Object)name);
                PipelineConfigProjectProperty pcpp = (PipelineConfigProjectProperty)job.getProperty(PipelineConfigProjectProperty.class);
                if (pcpp == null) {
                    this.logger.warn("No old property PipelineConfigProjectProperty for PipelineConfig '{}/{}', will skip add property for it.", (Object)namespace, (Object)name);
                    wfJobProperty = WorkflowJobProperty.getInstance(pipelineConfig);
                    job.addProperty((JobProperty)wfJobProperty);
                } else {
                    wfJobProperty = pcpp;
                }
            }
            wfJobProperty.setResourceVersion(pipelineConfig.getMetadata().getResourceVersion());
        }
        job.setDisplayName(this.mapper.jenkinsDisplayName(namespace, name));
        FlowDefinition flowDefinition = PipelineConfigToJobMapper.mapPipelineConfigToFlow(pipelineConfig);
        if (flowDefinition == null) {
            throw new PipelineConfigConvertException(new String[]{String.format("Unable to convert PipelineConfig to Jenkins job '%s/%s'", namespace, name)});
        }
        job.setDefinition(flowDefinition);
        job.setConcurrentBuild(!"Serial".equals(pipelineConfig.getSpec().getRunPolicy()));
        JenkinsUtils.addJobParamForPipelineParameters(job, pipelineConfig.getSpec().getParameters(), true);
        List<ANTLRException> triggerExceptions = JenkinsUtils.setJobTriggers(job, pipelineConfig.getSpec().getTriggers());
        if (triggerExceptions.size() != 0) {
            throw new PipelineConfigConvertException(triggerExceptions.stream().map(Throwable::getMessage).collect(Collectors.toList()).toArray(new String[0]));
        }
        return job;
    }
}

