/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.listener;

import com.google.common.base.Objects;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import io.alauda.devops.java.client.models.V1alpha1PipelineConfig;
import io.alauda.devops.java.client.models.V1alpha1PipelineConfigSpec;
import io.alauda.devops.java.client.models.V1alpha1PipelineSource;
import io.alauda.devops.java.client.models.V1alpha1PipelineSourceGit;
import io.alauda.devops.java.client.models.V1alpha1PipelineStrategy;
import io.alauda.devops.java.client.models.V1alpha1PipelineStrategyJenkins;
import io.alauda.devops.java.client.utils.DeepCopyUtils;
import io.alauda.jenkins.devops.sync.PipelineConfigToJobMapper;
import io.alauda.jenkins.devops.sync.WorkflowJobProperty;
import io.alauda.jenkins.devops.sync.client.Clients;
import io.alauda.jenkins.devops.sync.client.JenkinsClient;
import io.alauda.jenkins.devops.sync.controller.predicates.BindResourcePredicate;
import io.alauda.jenkins.devops.sync.listener.ItemEventHandler;
import io.alauda.jenkins.devops.sync.util.WorkflowJobUtils;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1Status;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;

@Extension
public class WorkflowEventHandler
implements ItemEventHandler<WorkflowJob> {
    private static final Logger logger = Logger.getLogger(WorkflowEventHandler.class.getName());
    private JenkinsClient jenkinsClient = JenkinsClient.getInstance();

    @Override
    public boolean accept(Item item) {
        if (!(item instanceof WorkflowJob)) {
            return false;
        }
        ItemGroup parent = item.getParent();
        return !(parent instanceof WorkflowMultiBranchProject);
    }

    @Override
    public void onCreated(WorkflowJob item) {
        this.upsertWorkflowJob(item);
    }

    @Override
    public void onUpdated(WorkflowJob item) {
        logger.log(Level.FINE, "onUpdated {0}", item);
        this.upsertWorkflowJob(item);
    }

    @Override
    public void onDeleted(WorkflowJob item) {
        WorkflowJobProperty property = this.pipelineConfigProjectForJob(item);
        if (property != null) {
            String namespace = property.getNamespace();
            String pipelineConfigName = property.getName();
            V1alpha1PipelineConfig pipelineConfig = (V1alpha1PipelineConfig)Clients.get(V1alpha1PipelineConfig.class).lister().namespace(namespace).get(pipelineConfigName);
            if (pipelineConfig != null) {
                logger.info(() -> "Got pipeline config for  " + namespace + "/" + pipelineConfigName);
                V1Status result = Clients.get(V1alpha1PipelineConfig.class).delete(namespace, pipelineConfigName);
                logger.info(() -> "Deleting PipelineConfig " + namespace + "/" + pipelineConfigName);
            } else {
                logger.info(() -> "No pipeline config for " + namespace + "/" + pipelineConfigName);
            }
        }
    }

    private void upsertWorkflowJob(WorkflowJob job) {
        WorkflowJobProperty property = this.pipelineConfigProjectForJob(job);
        if (property != null && this.isNotDeleteInProgress(property)) {
            logger.info(() -> "Upsert WorkflowJob " + job.getName() + " to PipelineConfig: " + property.getNamespace() + "/" + property.getName() + " in Alauda Kubernetes");
            this.upsertPipelineConfigForJob(job, property);
        } else {
            logger.log(Level.FINE, "skip job {0}, it is not created by alauda", job);
        }
    }

    private WorkflowJobProperty pipelineConfigProjectForJob(WorkflowJob job) {
        WorkflowJobProperty property = WorkflowJobUtils.getAlaudaProperty((Job)job);
        if (property != null && StringUtils.isNotBlank((String)property.getNamespace()) && StringUtils.isNotBlank((String)property.getName())) {
            logger.info("Found WorkflowJobProperty for namespace: " + property.getNamespace() + " name: " + property.getName());
            return property;
        }
        return null;
    }

    private boolean isNotDeleteInProgress(WorkflowJobProperty property) {
        return !this.jenkinsClient.isDeleteInProgress(property.getNamespace(), property.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upsertPipelineConfigForJob(WorkflowJob job, WorkflowJobProperty workflowJobProperty) {
        String namespace = workflowJobProperty.getNamespace();
        String jobName = workflowJobProperty.getName();
        V1alpha1PipelineConfig jobPipelineConfig = (V1alpha1PipelineConfig)Clients.get(V1alpha1PipelineConfig.class).lister().namespace(namespace).get(jobName);
        if (jobPipelineConfig == null) {
            logger.log(Level.WARNING, String.format("Unable to found mapped PipelineConfig '%s/%s' for Jenkins job %s, may have a potential bug", namespace, jobName, job.getFullDisplayName()));
            return;
        }
        if (!BindResourcePredicate.isBindedResource(namespace, jobPipelineConfig.getSpec().getJenkinsBinding().getName())) {
            logger.log(Level.WARNING, String.format(" PipelineConfigController: '%s/%s' is not bind to correct jenkinsbinding, will skip it", namespace, jobName));
            return;
        }
        String string = jobPipelineConfig.getMetadata().getUid().intern();
        synchronized (string) {
            V1ObjectMeta metadata = jobPipelineConfig.getMetadata();
            String uid = workflowJobProperty.getUid();
            if (StringUtils.isEmpty((String)uid)) {
                workflowJobProperty.setUid(metadata.getUid());
            } else if (!Objects.equal((Object)uid, (Object)metadata.getUid())) {
                logger.log(Level.WARNING, String.format("PipelineConfig '%s/%s' 's UUID %s is different from local %s, will skip it", namespace, job, metadata.getUid(), uid));
                return;
            }
            V1alpha1PipelineConfig newJobPipelineConfig = (V1alpha1PipelineConfig)DeepCopyUtils.deepCopy((Object)jobPipelineConfig);
            PipelineConfigToJobMapper.updatePipelineConfigFromJob(job, newJobPipelineConfig);
            if (!this.hasEmbeddedPipelineOrValidSource(newJobPipelineConfig)) {
                return;
            }
            try {
                Clients.get(V1alpha1PipelineConfig.class).update(jobPipelineConfig, newJobPipelineConfig);
                logger.info("PipelineConfig update success, " + jobName);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to update PipelineConfig: " + namespace + jobName + ". " + e, e);
            }
        }
    }

    private boolean hasEmbeddedPipelineOrValidSource(V1alpha1PipelineConfig pipelineConfig) {
        V1alpha1PipelineStrategyJenkins jenkinsPipelineStrategy;
        V1alpha1PipelineStrategy strategy;
        V1alpha1PipelineConfigSpec spec = pipelineConfig.getSpec();
        if (spec != null && (strategy = spec.getStrategy()) != null && (jenkinsPipelineStrategy = strategy.getJenkins()) != null) {
            V1alpha1PipelineSourceGit git;
            V1alpha1PipelineSource source;
            if (StringUtils.isNotBlank((String)jenkinsPipelineStrategy.getJenkinsfile())) {
                return true;
            }
            if (StringUtils.isNotBlank((String)jenkinsPipelineStrategy.getJenkinsfilePath()) && (source = spec.getSource()) != null && (git = source.getGit()) != null) {
                return StringUtils.isNotBlank((String)git.getUri());
            }
        }
        return false;
    }
}

