/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.listener;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import io.alauda.jenkins.devops.sync.AlaudaSyncGlobalConfiguration;
import io.alauda.jenkins.devops.sync.controller.ResourceSyncManager;
import io.alauda.jenkins.devops.sync.listener.ItemEventHandler;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

@Extension
public class JenkinsPipelineJobListener
extends ItemListener {
    private static final Logger logger = Logger.getLogger(JenkinsPipelineJobListener.class.getName());
    private final ExtensionList<ItemEventHandler> handler = Jenkins.getInstance().getExtensionList(ItemEventHandler.class);
    private String jenkinsService;
    private String jobNamePattern;

    @DataBoundConstructor
    public JenkinsPipelineJobListener() {
        AlaudaSyncGlobalConfiguration config = AlaudaSyncGlobalConfiguration.get();
        this.jenkinsService = config.getJenkinsService();
        this.jobNamePattern = config.getJobNamePattern();
        this.init();
    }

    private void init() {
    }

    public void onCreated(Item item) {
        if (!ResourceSyncManager.getSyncManager().isStarted()) {
            return;
        }
        logger.info(String.format("created item: %s", item.getFullName()));
        this.handler.stream().filter(handler -> handler.accept(item)).forEach(handler -> handler.onCreated(item));
        this.reconfigure();
    }

    public void onUpdated(Item item) {
        if (!ResourceSyncManager.getSyncManager().isStarted()) {
            return;
        }
        logger.info(String.format("updated item: %s", item.getFullName()));
        this.handler.stream().filter(handler -> handler.accept(item)).forEach(handler -> handler.onUpdated(item));
        this.reconfigure();
    }

    public void onDeleted(Item item) {
        if (!ResourceSyncManager.getSyncManager().isStarted()) {
            logger.info("no configuration... onDelete ignored...");
            return;
        }
        logger.info(String.format("deleted Item: %s", item.getFullName()));
        this.handler.stream().filter(handler -> handler.accept(item)).forEach(handler -> handler.onDeleted(item));
        this.reconfigure();
    }

    private void reconfigure() {
        AlaudaSyncGlobalConfiguration config = AlaudaSyncGlobalConfiguration.get();
        if (config != null) {
            this.jobNamePattern = config.getJobNamePattern();
            this.jenkinsService = config.getJenkinsService();
            this.init();
        }
    }

    public String toString() {
        return "JenkinsPipelineJobListener{, jenkinsService='" + this.jenkinsService + '\'' + ", jobNamePattern='" + this.jobNamePattern + '\'' + '}';
    }
}

