/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.credential;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.Extension;
import io.alauda.jenkins.plugins.credentials.SecretUtils;
import io.alauda.jenkins.plugins.credentials.convertor.CredentialsConversionException;
import io.alauda.jenkins.plugins.credentials.convertor.SecretToCredentialConverter;
import io.kubernetes.client.models.V1Secret;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

@Extension
public class DockerCredentialsConverter
extends SecretToCredentialConverter {
    public boolean canConvert(String s) {
        return "kubernetes.io/dockerconfigjson".equals(s);
    }

    public IdCredentials convert(V1Secret secret) throws CredentialsConversionException {
        JSONObject dockerAuthData;
        SecretUtils.requireNonNull((Object)secret.getData(), (String)"kubernetes.io/dockerconfigjson definition contains no data");
        String dockerData = SecretUtils.getNonNullSecretData((V1Secret)secret, (String)".dockerconfigjson", (String)"kubernetes.io/dockerconfigjson credential is missing the .dockerconfigjson");
        try {
            dockerAuthData = new JSONObject(dockerData);
        }
        catch (JSONException e) {
            throw new CredentialsConversionException(String.format("Unable to convert kubernetes.io/dockerconfigjson secret %s/%s", secret.getMetadata().getNamespace(), secret.getMetadata().getName()), (Throwable)e);
        }
        JSONObject auths = dockerAuthData.getJSONObject("auths");
        if (auths == null) {
            throw new CredentialsConversionException(String.format("Auths key in dockerconfigjson %s/%s is null", secret.getMetadata().getNamespace(), secret.getMetadata().getName()));
        }
        while (auths.keys().hasNext()) {
            JSONObject authData;
            String key = (String)auths.keys().next();
            if (StringUtils.isEmpty((CharSequence)key) || (authData = auths.getJSONObject(key)) == null) continue;
            String username = authData.getString("username");
            String password = authData.getString("password");
            if (StringUtils.isEmpty((CharSequence)username) && StringUtils.isEmpty((CharSequence)password)) continue;
            return new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, SecretUtils.getCredentialId((V1Secret)secret), SecretUtils.getCredentialDescription((V1Secret)secret), username, password);
        }
        return null;
    }
}

