/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.controller.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;

public final class Wait {
    private Wait() {
    }

    public static <T> void waitUntil(T t, Predicate<T> predicate, long period, long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
        CompletableFuture completedFuture = new CompletableFuture();
        ScheduledFuture<?> scheduledFuture = scheduledExecutor.scheduleAtFixedRate(() -> {
            if (predicate.test(t)) {
                completedFuture.complete(null);
            }
        }, period, period, timeUnit);
        completedFuture.whenComplete((v, throwable) -> scheduledFuture.cancel(true));
        completedFuture.get(timeout, timeUnit);
    }
}

