/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.controller;

import hudson.Extension;
import io.alauda.devops.java.client.apis.DevopsAlaudaIoV1alpha1Api;
import io.alauda.devops.java.client.models.V1alpha1Condition;
import io.alauda.devops.java.client.models.V1alpha1PipelineConfig;
import io.alauda.devops.java.client.models.V1alpha1PipelineConfigList;
import io.alauda.devops.java.client.utils.DeepCopyUtils;
import io.alauda.jenkins.devops.sync.AlaudaSyncGlobalConfiguration;
import io.alauda.jenkins.devops.sync.client.Clients;
import io.alauda.jenkins.devops.sync.client.JenkinsClient;
import io.alauda.jenkins.devops.sync.client.PipelineConfigClient;
import io.alauda.jenkins.devops.sync.controller.ResourceSyncController;
import io.alauda.jenkins.devops.sync.controller.predicates.BindResourcePredicate;
import io.alauda.jenkins.devops.sync.controller.util.InformerUtils;
import io.alauda.jenkins.devops.sync.exception.ConditionsUtils;
import io.alauda.jenkins.devops.sync.exception.PipelineConfigConvertException;
import io.alauda.jenkins.devops.sync.util.NamespaceName;
import io.alauda.jenkins.devops.sync.util.PipelineConfigUtils;
import io.kubernetes.client.extended.controller.Controller;
import io.kubernetes.client.extended.controller.builder.ControllerBuilder;
import io.kubernetes.client.extended.controller.builder.ControllerManagerBuilder;
import io.kubernetes.client.extended.controller.reconciler.Reconciler;
import io.kubernetes.client.extended.controller.reconciler.Request;
import io.kubernetes.client.extended.controller.reconciler.Result;
import io.kubernetes.client.extended.workqueue.WorkQueue;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class PipelineConfigController
implements ResourceSyncController {
    private static final Logger logger = LoggerFactory.getLogger(PipelineConfigController.class);
    private static final String CONTROLLER_NAME = "PipelineConfigController";

    @Override
    public void add(ControllerManagerBuilder managerBuilder, SharedInformerFactory factory) {
        DevopsAlaudaIoV1alpha1Api api = new DevopsAlaudaIoV1alpha1Api();
        SharedIndexInformer informer = InformerUtils.getExistingSharedIndexInformer(factory, V1alpha1PipelineConfig.class);
        if (informer == null) {
            informer = factory.sharedIndexInformerFor(callGeneratorParams -> api.listPipelineConfigForAllNamespacesCall(null, null, null, null, null, null, callGeneratorParams.resourceVersion, callGeneratorParams.timeoutSeconds, callGeneratorParams.watch, null, null), V1alpha1PipelineConfig.class, V1alpha1PipelineConfigList.class, TimeUnit.MINUTES.toMillis(AlaudaSyncGlobalConfiguration.get().getResyncPeriod()));
        }
        PipelineConfigClient client = new PipelineConfigClient(informer);
        Clients.register(V1alpha1PipelineConfig.class, client);
        Controller controller = ControllerBuilder.defaultBuilder((SharedInformerFactory)factory).watch(workQueue -> ControllerBuilder.controllerWatchBuilder(V1alpha1PipelineConfig.class, (WorkQueue)workQueue).withWorkQueueKeyFunc(pipelineConfig -> new Request(pipelineConfig.getMetadata().getNamespace(), pipelineConfig.getMetadata().getName())).withOnAddFilter(pipelineConfig -> {
            if (pipelineConfig.getStatus().getPhase().equals("Creating")) {
                logger.debug("[{}] phase of PipelineConfig '{}/{}' is {}, will skip it", new Object[]{CONTROLLER_NAME, pipelineConfig.getMetadata().getNamespace(), pipelineConfig.getMetadata().getName(), "Creating"});
                return false;
            }
            logger.debug("[{}] receives event: Add; PipelineConfig '{}/{}'", new Object[]{CONTROLLER_NAME, pipelineConfig.getMetadata().getNamespace(), pipelineConfig.getMetadata().getName()});
            return true;
        }).withOnUpdateFilter((oldPipelineConfig, newPipelineConfig) -> {
            String namespace = oldPipelineConfig.getMetadata().getNamespace();
            String name = oldPipelineConfig.getMetadata().getName();
            if (oldPipelineConfig.getMetadata().getResourceVersion().equals(newPipelineConfig.getMetadata().getResourceVersion())) {
                logger.debug("[{}] resourceVersion of PipelineConfig '{}/{}' is equal, will skip update event for it", new Object[]{CONTROLLER_NAME, namespace, name});
                return false;
            }
            if (newPipelineConfig.getStatus().getPhase().equals("Creating")) {
                logger.debug("[{}] phase of PipelineConfig '{}/{}' is {}, will skip it", new Object[]{CONTROLLER_NAME, namespace, name, "Creating"});
                return false;
            }
            logger.debug("[{}] receives event: Update; PipelineConfig '{}/{}'", new Object[]{CONTROLLER_NAME, namespace, name});
            return true;
        }).withOnDeleteFilter((pipelineConfig, aBoolean) -> {
            logger.debug("[{}] receives event: Delete; PipelineConfig '{}/{}'", new Object[]{CONTROLLER_NAME, pipelineConfig.getMetadata().getNamespace(), pipelineConfig.getMetadata().getName()});
            return true;
        }).build()).withReconciler((Reconciler)new PipelineConfigReconciler((Lister<V1alpha1PipelineConfig>)new Lister(informer.getIndexer()))).withName(CONTROLLER_NAME).withReadyFunc(Clients::allRegisteredResourcesSynced).withWorkerCount(4).build();
        managerBuilder.addController(controller);
    }

    static class PipelineConfigReconciler
    implements Reconciler {
        private Lister<V1alpha1PipelineConfig> lister;
        private JenkinsClient jenkinsClient;

        public PipelineConfigReconciler(Lister<V1alpha1PipelineConfig> lister) {
            this.lister = lister;
            this.jenkinsClient = JenkinsClient.getInstance();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Result reconcile(Request request) {
            String namespace = request.getNamespace();
            String name = request.getName();
            V1alpha1PipelineConfig pc = (V1alpha1PipelineConfig)this.lister.namespace(namespace).get(name);
            if (pc == null) {
                logger.debug("[{}] Cannot found PipelineConfig '{}/{}' in local lister, will try to remove it's correspondent Jenkins job", new Object[]{this.getControllerName(), namespace, name});
                try {
                    boolean deleteSucceed = this.jenkinsClient.deleteJob(new NamespaceName(namespace, name));
                    if (!deleteSucceed) {
                        logger.warn("[{}] Failed to delete job for PipelineConfig '{}/{}'", new Object[]{this.getControllerName(), namespace, name});
                    }
                }
                catch (IOException | InterruptedException e) {
                    logger.warn("[{}] Failed to delete job for PipelineConfig '{}/{}', reason {}", new Object[]{this.getControllerName(), namespace, name, e.getMessage()});
                    Thread.currentThread().interrupt();
                }
                return new Result(false);
            }
            if (!BindResourcePredicate.isBindedResource(namespace, pc.getSpec().getJenkinsBinding().getName())) {
                logger.debug("[{}] PipelineConfigController: {}/{}' is not bind to correct jenkinsbinding, will skip it", new Object[]{this.getControllerName(), namespace, name});
                return new Result(false);
            }
            logger.debug("[{}] Start to create or update Jenkins job for PipelineConfig '{}/{}'", new Object[]{this.getControllerName(), namespace, name});
            V1alpha1PipelineConfig pipelineConfigCopy = (V1alpha1PipelineConfig)DeepCopyUtils.deepCopy((Object)pc);
            String string = pc.getMetadata().getUid().intern();
            synchronized (string) {
                ArrayList<V1alpha1Condition> conditions = new ArrayList<V1alpha1Condition>();
                pipelineConfigCopy.getStatus().setConditions(conditions);
                PipelineConfigUtils.dependencyCheck(pipelineConfigCopy, pipelineConfigCopy.getStatus().getConditions());
                try {
                    if (this.jenkinsClient.hasSyncedJenkinsJob(pipelineConfigCopy)) {
                        return new Result(false);
                    }
                    if (!this.jenkinsClient.upsertJob(pipelineConfigCopy)) {
                        return new Result(false);
                    }
                }
                catch (PipelineConfigConvertException e) {
                    logger.warn("[{}] Failed to convert PipelineConfig '{}/{}' to Jenkins Job, reason {}", new Object[]{this.getControllerName(), namespace, name, StringUtils.join((Object[])e.getCauses(), (String)" or ")});
                    conditions.addAll(ConditionsUtils.convertToConditions(e.getCauses()));
                }
                catch (IOException e) {
                    logger.warn("[{}] Failed to convert PipelineConfig '{}/{}' to Jenkins Job, reason {}", new Object[]{this.getControllerName(), namespace, name, e.getMessage()});
                    conditions.add(ConditionsUtils.convertToCondition(e));
                }
                if (pipelineConfigCopy.getStatus().getConditions().size() > 0) {
                    pipelineConfigCopy.getStatus().setPhase("Error");
                    DateTime now = DateTime.now();
                    pipelineConfigCopy.getStatus().getConditions().forEach(c -> c.setLastAttempt(now));
                } else {
                    pipelineConfigCopy.getStatus().setPhase("Ready");
                }
                logger.debug("[{}] Will update PipelineConfig '{}/{}'", new Object[]{this.getControllerName(), namespace, name});
                PipelineConfigClient pipelineConfigClient = (PipelineConfigClient)Clients.get(V1alpha1PipelineConfig.class);
                boolean succeed = pipelineConfigClient.update(pc, pipelineConfigCopy);
                return new Result(!succeed);
            }
        }

        private String getControllerName() {
            return PipelineConfigController.CONTROLLER_NAME;
        }
    }
}

