/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.controller;

import com.cloudbees.hudson.plugins.folder.Folder;
import hudson.Extension;
import hudson.security.ACL;
import hudson.security.ACLContext;
import io.alauda.jenkins.devops.sync.AlaudaFolderProperty;
import io.alauda.jenkins.devops.sync.AlaudaSyncGlobalConfiguration;
import io.alauda.jenkins.devops.sync.client.Clients;
import io.alauda.jenkins.devops.sync.client.NamespaceClient;
import io.alauda.jenkins.devops.sync.controller.ResourceSyncController;
import io.alauda.jenkins.devops.sync.controller.util.InformerUtils;
import io.kubernetes.client.apis.CoreV1Api;
import io.kubernetes.client.extended.controller.Controller;
import io.kubernetes.client.extended.controller.builder.ControllerBuilder;
import io.kubernetes.client.extended.controller.builder.ControllerManagerBuilder;
import io.kubernetes.client.extended.controller.reconciler.Reconciler;
import io.kubernetes.client.extended.controller.reconciler.Request;
import io.kubernetes.client.extended.controller.reconciler.Result;
import io.kubernetes.client.extended.workqueue.WorkQueue;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.models.V1Namespace;
import io.kubernetes.client.models.V1NamespaceList;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class NamespaceController
implements ResourceSyncController {
    private static final Logger logger = LoggerFactory.getLogger(NamespaceController.class);
    private static final String CONTROLLER_NAME = "NamespaceController";

    @Override
    public void add(ControllerManagerBuilder managerBuilder, SharedInformerFactory factory) {
        CoreV1Api api = new CoreV1Api();
        SharedIndexInformer informer = InformerUtils.getExistingSharedIndexInformer(factory, V1Namespace.class);
        if (informer == null) {
            informer = factory.sharedIndexInformerFor(callGeneratorParams -> api.listNamespaceCall(null, null, null, null, null, callGeneratorParams.resourceVersion, callGeneratorParams.timeoutSeconds, callGeneratorParams.watch, null, null), V1Namespace.class, V1NamespaceList.class, TimeUnit.MINUTES.toMillis(AlaudaSyncGlobalConfiguration.get().getResyncPeriod()));
        }
        NamespaceClient client = new NamespaceClient(informer);
        Clients.register(V1Namespace.class, client);
        Controller controller = ControllerBuilder.defaultBuilder((SharedInformerFactory)factory).watch(workQueue -> ControllerBuilder.controllerWatchBuilder(V1Namespace.class, (WorkQueue)workQueue).withWorkQueueKeyFunc(namespace -> new Request(namespace.getMetadata().getName())).build()).withReconciler((Reconciler)new NamespaceReconciler((Lister<V1Namespace>)new Lister(informer.getIndexer()))).withName(CONTROLLER_NAME).withReadyFunc(() -> ((SharedIndexInformer)informer).hasSynced()).withWorkerCount(1).build();
        managerBuilder.addController(controller);
    }

    static class NamespaceReconciler
    implements Reconciler {
        private Lister<V1Namespace> namespaceLister;

        public NamespaceReconciler(Lister<V1Namespace> namespaceLister) {
            this.namespaceLister = namespaceLister;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public Result reconcile(Request request) {
            V1Namespace namespace = (V1Namespace)this.namespaceLister.get(request.getName());
            if (namespace != null) {
                return new Result(false);
            }
            String folderName = request.getName();
            try {
                Throwable throwable = null;
                try (ACLContext ignored = ACL.as((Authentication)ACL.SYSTEM);){
                    Folder folder = (Folder)Jenkins.getInstance().getItemByFullName(folderName, Folder.class);
                    if (folder == null) {
                        logger.warn("[{}] Folder {} can't found.", (Object)NamespaceController.CONTROLLER_NAME, (Object)folderName);
                        Result result = new Result(false);
                        return result;
                    }
                    AlaudaFolderProperty alaudaFolderProperty = (AlaudaFolderProperty)folder.getProperties().get(AlaudaFolderProperty.class);
                    if (alaudaFolderProperty == null) {
                        logger.debug("[{}] Folder {} don't have AbstractFolderProperty, will skip it.", (Object)NamespaceController.CONTROLLER_NAME, (Object)folderName);
                        Result result = new Result(false);
                        return result;
                    }
                    int itemCount = folder.getItems().size();
                    if (itemCount > 0) {
                        logger.debug("[{}] Will not delete folder {} that still has items, count {}.", new Object[]{NamespaceController.CONTROLLER_NAME, folderName, itemCount});
                        alaudaFolderProperty.setDirty(true);
                        try {
                            folder.save();
                        }
                        catch (IOException e) {
                            logger.warn("[{}] Unable to save folder {}, reason: {}", new Object[]{NamespaceController.CONTROLLER_NAME, folderName, e});
                        }
                        Result e = new Result(false);
                        return e;
                    }
                    try {
                        folder.delete();
                    }
                    catch (IOException e) {
                        logger.warn("[{}] Failed to delete folder {}, reason: {}", new Object[]{NamespaceController.CONTROLLER_NAME, folderName, e});
                        Result result = new Result(true);
                        if (ignored != null) {
                            if (throwable != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            } else {
                                ignored.close();
                            }
                        }
                        return result;
                    }
                    catch (InterruptedException e) {
                        try {
                            logger.warn("[{}] Failed to delete folder {}, reason: {}", new Object[]{NamespaceController.CONTROLLER_NAME, folderName, e});
                            Thread.currentThread().interrupt();
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throw throwable4;
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.info("[{}] Unable to delete folder {}, reason {}", new Object[]{NamespaceController.CONTROLLER_NAME, folderName, e.getMessage()});
            }
            return new Result(false);
        }
    }
}

