/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync;

import com.cloudbees.hudson.plugins.folder.Folder;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.security.ACL;
import io.alauda.devops.java.client.apis.DevopsAlaudaIoV1alpha1Api;
import io.alauda.devops.java.client.models.V1alpha1PipelineConfig;
import io.alauda.jenkins.devops.sync.WorkflowJobProperty;
import io.alauda.jenkins.devops.sync.client.Clients;
import io.alauda.jenkins.devops.sync.controller.ResourceSyncManager;
import io.alauda.jenkins.devops.sync.util.WorkflowJobUtils;
import io.kubernetes.client.ApiException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class OrphanJobCheck
extends AsyncPeriodicWork {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)OrphanJobCheck.class.getName());
    private List<Item> orphanList = new ArrayList<Item>();

    public OrphanJobCheck() {
        super("OrphanJobCheck");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(TaskListener listener) throws IOException, InterruptedException {
        LOGGER.info("Start to scan orphan items.");
        this.orphanList.clear();
        SecurityContext previousContext = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            ResourceSyncManager resourceSyncManager = ResourceSyncManager.getSyncManager();
            if (!resourceSyncManager.isStarted()) {
                LOGGER.info("SyncManager has not started yet, reason {}, will skip this Orphan Job check", (Object)resourceSyncManager.getPluginStatus());
                return;
            }
            this.scanOrphanItems();
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)previousContext);
        }
    }

    private void scanOrphanItems() {
        Jenkins jenkins = Jenkins.getInstance();
        List folders = jenkins.getItems(Folder.class);
        folders.forEach(folder -> folder.getItems().stream().filter(item -> {
            if (!(item instanceof WorkflowJob)) {
                return false;
            }
            WorkflowJobProperty pro = WorkflowJobUtils.getAlaudaProperty((Job)((WorkflowJob)item));
            return pro != null && pro.isValid();
        }).forEach(item -> {
            WorkflowJobProperty pro = WorkflowJobUtils.getAlaudaProperty((Job)((WorkflowJob)item));
            String ns = pro.getNamespace();
            String name = pro.getName();
            String uid = pro.getUid();
            V1alpha1PipelineConfig pc = (V1alpha1PipelineConfig)Clients.get(V1alpha1PipelineConfig.class).lister().namespace(ns).get(name);
            if (pc == null) {
                DevopsAlaudaIoV1alpha1Api api = new DevopsAlaudaIoV1alpha1Api();
                V1alpha1PipelineConfig newer = null;
                try {
                    newer = api.readNamespacedPipelineConfig(name, ns, null, null, null);
                }
                catch (ApiException e) {
                    LOGGER.debug("Unable to get newer pipelineConfig");
                    this.orphanList.add((Item)item);
                }
                if (newer == null || !newer.getMetadata().getUid().equals(uid)) {
                    this.orphanList.add((Item)item);
                }
            } else if (!pc.getMetadata().getUid().equals(uid)) {
                this.orphanList.add((Item)item);
            }
        }));
        LOGGER.info("Start to remove orphan items, total numbers {}.", (Object)this.orphanList.size());
        this.orphanList.forEach(item -> {
            try {
                item.delete();
                LOGGER.info("Remove orphan item [{}].", (Object)item.getFullName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        });
    }

    public long getRecurrencePeriod() {
        return TimeUnit.MINUTES.toMillis(15L);
    }
}

