/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync;

import com.cloudbees.hudson.plugins.folder.Folder;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import hudson.security.ACL;
import io.alauda.devops.java.client.models.V1alpha1JenkinsBinding;
import io.alauda.jenkins.devops.sync.AlaudaFolderProperty;
import io.alauda.jenkins.devops.sync.AlaudaSyncGlobalConfiguration;
import io.alauda.jenkins.devops.sync.WorkflowJobProperty;
import io.alauda.jenkins.devops.sync.client.Clients;
import io.alauda.jenkins.devops.sync.controller.ResourceSyncManager;
import io.kubernetes.client.models.V1Namespace;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class EmptyFolderCheck
extends AsyncPeriodicWork {
    private static final Logger logger = LoggerFactory.getLogger((String)EmptyFolderCheck.class.getName());

    public EmptyFolderCheck() {
        super("EmptyFolderCheck");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(TaskListener listener) throws IOException, InterruptedException {
        SecurityContext previousContext = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            List folders = Jenkins.getInstance().getItems(Folder.class);
            if (folders == null) {
                return;
            }
            ResourceSyncManager resourceSyncManager = ResourceSyncManager.getSyncManager();
            if (!resourceSyncManager.isStarted()) {
                logger.info("SyncManager has not started yet, reason {}, will skip this Empty Folder Check", (Object)resourceSyncManager.getPluginStatus());
                return;
            }
            folders.stream().filter(folder -> folder.getProperties().stream().anyMatch(pro -> {
                String folderName = folder.getName();
                return pro instanceof AlaudaFolderProperty && (((AlaudaFolderProperty)((Object)((Object)pro))).isDirty() || this.noneMatch(folderName) || this.noJenkinsBinding(folderName));
            })).filter(folder -> {
                Collection items = folder.getItems();
                if (items.isEmpty()) {
                    return true;
                }
                return items.stream().noneMatch((? super T item) -> {
                    if (item instanceof WorkflowJob) {
                        return ((WorkflowJob)item).getProperty(WorkflowJobProperty.class) == null;
                    }
                    return false;
                });
            }).forEach(folder -> {
                try {
                    folder.delete();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            });
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)previousContext);
        }
    }

    private boolean noJenkinsBinding(String target) {
        String jenkinsService = AlaudaSyncGlobalConfiguration.get().getJenkinsService();
        return Clients.get(V1alpha1JenkinsBinding.class).lister().list().stream().filter(jenkinsBinding -> jenkinsBinding.getSpec().getJenkins().getName().equals(jenkinsService)).map(jenkinsBinding -> jenkinsBinding.getMetadata().getNamespace()).distinct().noneMatch((? super T namespace) -> namespace.equalsIgnoreCase(target));
    }

    private boolean noneMatch(String target) {
        return Clients.get(V1Namespace.class).lister().list().stream().noneMatch((? super T namespace) -> namespace.getMetadata().getName().equalsIgnoreCase(target));
    }

    public long getRecurrencePeriod() {
        return TimeUnit.MINUTES.toMillis(10L);
    }
}

