/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.statistics.page;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import io.airbridge.AirBridge;
import io.airbridge.Config;
import io.airbridge.internal.StateOwner;
import io.airbridge.internal.log.Logger;
import io.airbridge.statistics.page.AppActiveState;

class Session
extends StateOwner<AppActiveState> {
    private static final int OFF_CONFIRM_TIMEOUT = 700;
    private static final int INACTIVE_TIMEOUT = 800;
    private static final String KEY_CURRENT_STATE = "current_state";
    private static final String KEY_PREVIOUS_STATE = "previous_state";
    boolean trackable = false;
    boolean isOnForeground = false;
    int createdCounter = 0;
    private Handler handler = new Handler();
    private Config config = Config.getInstance();
    private Runnable delayedCloseRunnable = new Runnable(){

        @Override
        public void run() {
            Session.this.closeSessionIfNeeded();
        }
    };

    public Session() {
        this.previousState = AppActiveState.OFF;
        this.currentState = AppActiveState.OFF;
    }

    private void start(Context context) {
        this.trackable = true;
        this.setState(AppActiveState.START);
    }

    public void createActivity(Activity activity) {
        if (Config.getInstance().isFirstTime()) {
            this.setState(AppActiveState.INSTALL);
            this.isOnForeground = true;
            this.addActivity(activity);
        }
        this.trackable = true;
    }

    public void activityResumed(Activity activity) {
        if (!this.isOnForeground) {
            this.isOnForeground = true;
            if (this.isTimeOut()) {
                if (this.createdCounter > 0) {
                    this.setState(AppActiveState.SESSIONACTIVE);
                    Logger.v("App is on session_foreground ", new Object[0]);
                } else {
                    this.setState(AppActiveState.SESSIONSTART);
                    Logger.v("Started launch session.", new Object[0]);
                    this.addActivity(activity);
                }
            } else if (this.createdCounter > 0) {
                this.setState(AppActiveState.ACTIVE);
                Logger.v("App is on foreground.", new Object[0]);
            } else {
                this.setState(AppActiveState.START);
                this.addActivity(activity);
                Logger.v("Started launch", new Object[0]);
            }
        } else {
            this.addActivity(activity);
        }
        this.trackable = false;
    }

    public void addActivity(Activity activity) {
        if (this.trackable) {
            ++this.createdCounter;
            Logger.i("Activity Added : %s (count=%d)", activity.getClass().getSimpleName(), this.createdCounter);
        }
    }

    public void background() {
        if (this.isOnForeground) {
            this.isOnForeground = false;
            this.setState(AppActiveState.INACTIVE);
            Logger.v("App is on background.", new Object[0]);
        }
    }

    public void removeActivity(Activity activity) {
        --this.createdCounter;
        if (this.createdCounter == 0) {
            this.setState(AppActiveState.OFF);
            this.handler.postDelayed(this.delayedCloseRunnable, 700L);
        }
        Logger.i("Activity Removed : %s (count=%d)", activity.getClass().getSimpleName(), this.createdCounter);
    }

    private void closeSessionIfNeeded() {
        if (this.createdCounter == 0) {
            this.trackable = false;
            Config.getInstance().updateLastSessionDate();
        } else {
            AppActiveState prevState = (AppActiveState)((Object)this.getPreviousState());
            this.setState(AppActiveState.OFF_CANCELLED);
            this.setState(prevState);
        }
    }

    private boolean isTimeOut() {
        return AirBridge.getLifecycleTime() < System.currentTimeMillis() - this.config.getBackgroundTimestamp();
    }
}

