/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.statistics.page;

import android.app.Activity;
import io.airbridge.internal.log.Logger;
import io.airbridge.statistics.page.PageInfo;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class PageInfoRegistry {
    PageInfo currentPageInfo = new PageInfo();
    Map<String, PageInfo> pageInfoCache = new HashMap<String, PageInfo>();

    public void register(Activity activity) {
        PageInfo pageInfo = this.pageInfoCache.get(activity.getClass().getName());
        if (pageInfo == null) {
            pageInfo = new PageInfo(activity);
            this.pageInfoCache.put(activity.getClass().getName(), pageInfo);
        }
        pageInfo.activity = new WeakReference<Activity>(activity);
    }

    public void setCurrentPage(Activity activity) {
        PageInfo pageInfo = this.pageInfoCache.get(activity.getClass().getName());
        if (pageInfo == null) {
            Logger.e("PageInfo is not registered.");
        }
        this.currentPageInfo = pageInfo;
    }

    public void setCurrentPageName(String name) {
        if (this.currentPageInfo == null) {
            throw new IllegalStateException("You need to set current page first.");
        }
        this.currentPageInfo.name = name;
    }

    public void setCurrentPageData(String key, Object value) {
        if (this.currentPageInfo == null) {
            throw new IllegalStateException("You need to set current page first.");
        }
        this.currentPageInfo.customInfo.put(key, value);
    }

    public Activity getCurrentActivity() {
        if (this.currentPageInfo == null) {
            throw new IllegalStateException("You need to set current page first.");
        }
        return (Activity)this.currentPageInfo.activity.get();
    }

    public JSONObject getCurrentPageData() {
        return this.currentPageInfo != null ? this.currentPageInfo.toJson() : new JSONObject();
    }

    PageInfo getCurrentPageInfo() {
        return this.currentPageInfo;
    }

    public boolean isTrackable(Activity activity) {
        PageInfo pageInfo = this.pageInfoCache.get(activity.getClass().getName());
        if (pageInfo != null) {
            return pageInfo.isTrackable;
        }
        return false;
    }
}

