/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.statistics.page;

import android.app.Activity;
import io.airbridge.internal.JsonConvertible;
import io.airbridge.internal.Param;
import io.airbridge.statistics.page.DontTrack;
import io.airbridge.statistics.page.Page;
import java.lang.ref.WeakReference;
import org.json.JSONObject;

class PageInfo
implements JsonConvertible {
    public String name;
    public String componentName;
    public Param customInfo = new Param();
    public WeakReference<Activity> activity;
    public boolean isTrackable;

    public PageInfo(Activity activity) {
        this.name = this.getPageName(activity);
        this.componentName = activity.getClass().getName();
        this.activity = new WeakReference<Activity>(activity);
        this.isTrackable = this.isActivityTrackable(activity);
    }

    private String getPageName(Activity activity) {
        Page pageAnnotation = activity.getClass().getAnnotation(Page.class);
        if (pageAnnotation != null) {
            return pageAnnotation.value();
        }
        return activity.getTitle().toString();
    }

    public String getComponentName() {
        return this.componentName;
    }

    public PageInfo() {
    }

    @Override
    public JSONObject toJson() {
        return new Param().put("name", this.name).put("packageName", this.componentName).put("customInfo", this.customInfo).toJson();
    }

    private boolean isActivityTrackable(Activity activity) {
        return activity.getClass().getAnnotation(DontTrack.class) == null;
    }
}

