/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.statistics.page;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.VisibleForTesting;
import io.airbridge.Config;
import io.airbridge.internal.StateOwner;
import io.airbridge.internal.log.Logger;
import io.airbridge.internal.tasks.AirBridgeExecutor;
import io.airbridge.statistics.DeepLinkStatus;
import io.airbridge.statistics.Installer;
import io.airbridge.statistics.Tracker;
import io.airbridge.statistics.events.AppShutdownEvent;
import io.airbridge.statistics.events.BackgroundEvent;
import io.airbridge.statistics.events.BatchEvent;
import io.airbridge.statistics.events.ForegroundEvent;
import io.airbridge.statistics.events.LaunchEvent;
import io.airbridge.statistics.events.PageViewEvent;
import io.airbridge.statistics.events.SessionForgroundEvent;
import io.airbridge.statistics.events.SessionLaunchEvent;
import io.airbridge.statistics.page.AppActiveState;
import io.airbridge.statistics.page.LifecycleCallBack;
import io.airbridge.statistics.page.PageInfoRegistry;
import io.airbridge.statistics.page.Session;

public class LifecycleTracker {
    private PageInfoRegistry pageInfoRegistry;
    private Tracker tracker;
    private Session session = new Session();
    LifecycleCallBack callback;
    static boolean autoLifecycleTracking = true;
    private boolean pageTrackingEnabled = false;

    public LifecycleTracker(Context context, PageInfoRegistry pageInfoRegistry) {
        this.pageInfoRegistry = pageInfoRegistry;
        if (autoLifecycleTracking) {
            this.registerActivityLifecycleHandler(context);
        }
        this.observeSession(context);
    }

    public static void disableAutoLifecycleTracking() {
        autoLifecycleTracking = false;
    }

    private void registerActivityLifecycleHandler(Context context) {
        if (Build.VERSION.SDK_INT >= 14) {
            this.callback = new LifecycleCallBack(this);
            Application app = (Application)context.getApplicationContext();
            app.registerComponentCallbacks((ComponentCallbacks)this.callback);
            app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.callback);
        } else {
            Logger.e("You're running lower than Android 4.0; but automatic lifecycle tracking is enabled. you need to disable it and do it manually.\nFor details, see https://docs.airbridge.io/ko/advance/2-5-3.html");
        }
    }

    private void observeSession(final Context context) {
        this.session.observe(AppActiveState.INSTALL, new StateOwner.Callback(){

            @Override
            public void call() {
                AirBridgeExecutor.runAfterTime(5000L, new Runnable(){

                    @Override
                    public void run() {
                        if (Config.getInstance().isFirstTime()) {
                            Installer.install(context);
                            LifecycleTracker.this.tracker.send(new BatchEvent());
                        }
                    }
                });
            }
        });
        this.session.observe(AppActiveState.SESSIONSTART, new StateOwner.Callback(){

            @Override
            public void call() {
                AirBridgeExecutor.runAfterTime(2000L, new Runnable(){

                    @Override
                    public void run() {
                        LifecycleTracker.this.tracker.send(new SessionLaunchEvent());
                        DeepLinkStatus.getInstance().clear();
                        LifecycleTracker.this.tracker.send(new BatchEvent());
                    }
                });
            }
        });
        this.session.observe(AppActiveState.SESSIONACTIVE, new StateOwner.Callback(){

            @Override
            public void call() {
                AirBridgeExecutor.runAfterTime(2000L, new Runnable(){

                    @Override
                    public void run() {
                        if (LifecycleTracker.this.session.getPreviousState() == AppActiveState.INACTIVE) {
                            LifecycleTracker.this.tracker.send(new SessionForgroundEvent());
                            DeepLinkStatus.getInstance().clear();
                            LifecycleTracker.this.tracker.send(new BatchEvent());
                        }
                    }
                });
            }
        });
        this.session.observe(AppActiveState.START, new StateOwner.Callback(){

            @Override
            public void call() {
                AirBridgeExecutor.runAfterTime(2000L, new Runnable(){

                    @Override
                    public void run() {
                        LifecycleTracker.this.tracker.send(new LaunchEvent());
                        DeepLinkStatus.getInstance().clear();
                        LifecycleTracker.this.tracker.send(new BatchEvent());
                    }
                });
            }
        });
        this.session.observe(AppActiveState.ACTIVE, new StateOwner.Callback(){

            @Override
            public void call() {
                if (LifecycleTracker.this.session.getPreviousState() == AppActiveState.INACTIVE) {
                    LifecycleTracker.this.tracker.send(new ForegroundEvent());
                }
            }
        });
        this.session.observe(AppActiveState.INACTIVE, new StateOwner.Callback(){

            @Override
            public void call() {
                LifecycleTracker.this.tracker.send(new BackgroundEvent());
                Config.getInstance().setBackgroundTimestamp(System.currentTimeMillis());
            }
        });
        this.session.observe(AppActiveState.OFF, new StateOwner.Callback(){

            @Override
            public void call() {
                Logger.i("App is shutting down.", new Object[0]);
                LifecycleTracker.this.tracker.send(new AppShutdownEvent());
            }
        });
        this.session.observe(AppActiveState.OFF_CANCELLED, new StateOwner.Callback(){

            @Override
            public void call() {
                LifecycleTracker.this.tracker.cancelSending(new AppShutdownEvent().getCategory());
            }
        });
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        this.pageInfoRegistry.register(activity);
        if (!this.pageInfoRegistry.isTrackable(activity)) {
            return;
        }
        this.session.createActivity(activity);
    }

    public void onActivityResumed(Activity activity) {
        this.session.activityResumed(activity);
        if (activity.getClass().getName().equals(this.pageInfoRegistry.currentPageInfo.componentName)) {
            return;
        }
        this.pageInfoRegistry.setCurrentPage(activity);
        if (this.isPageTrackingEnabled() && this.pageInfoRegistry.isTrackable(activity)) {
            this.tracker.send(new PageViewEvent());
        }
    }

    public void onTrimMemory(int level) {
        if (level == 20) {
            Logger.d("createdCounter onTrimMemory : " + String.valueOf(this.session.createdCounter), new Object[0]);
            this.session.background();
        }
    }

    public void onActivityDestroyed(Activity activity) {
        if (!this.pageInfoRegistry.isTrackable(activity)) {
            return;
        }
        this.session.removeActivity(activity);
    }

    public void setTracker(Tracker tracker) {
        this.tracker = tracker;
    }

    public void setPageTrackingEnabled(boolean pageTrackingEnabled) {
        this.pageTrackingEnabled = pageTrackingEnabled;
    }

    public boolean isPageTrackingEnabled() {
        return this.pageTrackingEnabled;
    }

    public int getPreviousSessionStatus() {
        return ((AppActiveState)((Object)this.session.getPreviousState())).state;
    }

    @VisibleForTesting
    public void unregisterActivityLifecycleHandler(Context context) {
        if (Build.VERSION.SDK_INT >= 14) {
            Application app = (Application)context.getApplicationContext();
            app.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.callback);
            app.unregisterComponentCallbacks((ComponentCallbacks)this.callback);
        }
    }
}

