/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.statistics.events;

import io.airbridge.internal.Param;
import io.airbridge.statistics.Tracker;
import io.airbridge.statistics.events.Event;

public class GoalEvent
extends Event {
    private static final int EVENT_CATEGORY = 9360;
    private String category;
    private String action;
    private String label = "";
    private int value = 0;
    private Param customAttributes = new Param();

    public GoalEvent(String category) {
        this(category, null);
    }

    public GoalEvent(String category, String action) {
        this.category = category;
        this.action = action;
    }

    @Override
    public Param getEventData(Tracker tracker) {
        Param goalParam = new Param().put("category", this.category).put("action", this.action).put("label", this.label).put("value", this.value).put("customAttributes", this.customAttributes);
        Param semanticAttributes = this.getSemanticAttributes();
        if (semanticAttributes != null) {
            goalParam.put("semanticAttributes", semanticAttributes);
        }
        return new Param().put("goal", goalParam);
    }

    protected Param getSemanticAttributes() {
        return null;
    }

    public GoalEvent setLabel(String label) {
        this.label = label;
        return this;
    }

    public GoalEvent setCategory(String category) {
        this.category = category;
        return this;
    }

    public GoalEvent setAction(String action) {
        this.action = action;
        return this;
    }

    public GoalEvent setValue(int value) {
        this.value = value;
        return this;
    }

    public GoalEvent setCustomAttribute(String key, Object value) {
        this.customAttributes.put(key, value);
        return this;
    }

    public String getGoalCategory() {
        return this.category;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public int getCategory() {
        return 9360;
    }
}

