/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.statistics.events;

import io.airbridge.AirBridge;
import io.airbridge.Config;
import io.airbridge.deeplink.DeepLink;
import io.airbridge.internal.Param;
import io.airbridge.statistics.DeepLinkStatus;
import io.airbridge.statistics.Tracker;
import io.airbridge.statistics.events.Event;

public class DeepLinkLaunchEvent
extends Event {
    private static final int LAUNCH_EVENT_CATEGORY = 9168;
    private static final int SESSION_LAUNCH_EVENT_CATEGORY = 9162;
    private static final int SESSION_FIRST_LAUNCH_EVENT_CATEGORY = 9163;
    public static boolean trackAirbridgeLinkOnly = false;
    private String deeplinkUri;
    private DeepLinkStatus deepLinkState = DeepLinkStatus.getInstance();
    private Boolean timeOut;

    public DeepLinkLaunchEvent(DeepLink link) {
        this(link.toString());
    }

    public DeepLinkLaunchEvent(String deeplinkUri) {
        this.deeplinkUri = deeplinkUri;
        this.timeOut = this.isTimeOut();
    }

    @Override
    public void onBeforeSendingEvent() {
        super.onBeforeSendingEvent();
        this.deepLinkState.setState(DeepLinkStatus.State.DEEP_LINK_CLICKED);
        if (this.timeOut.booleanValue()) {
            Config.getInstance().setSessionID();
        }
    }

    @Override
    public Param getEventData(Tracker tracker) {
        Param param = new Param().put("deeplink", this.deeplinkUri);
        if (Config.getInstance().isFirstTime()) {
            param.put("systemInstallTimestamp", Config.getInstance().getInstallTime());
        }
        return param;
    }

    @Override
    public boolean canBeSent() {
        return !trackAirbridgeLinkOnly || DeepLink.isFromAirbridge(this.deeplinkUri);
    }

    @Override
    public int getCategory() {
        if (this.timeOut.booleanValue()) {
            return Config.getInstance().isFirstTime() ? 9163 : 9162;
        }
        return 9168;
    }

    private Boolean isTimeOut() {
        return AirBridge.getLifecycleTime() < System.currentTimeMillis() - Config.getInstance().getBackgroundTimestamp();
    }
}

