/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.statistics;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import io.airbridge.AirBridge;
import io.airbridge.Config;
import io.airbridge.Constants;
import io.airbridge.deviceinfo.DeviceInfo;
import io.airbridge.deviceinfo.InstallReferrerProvider;
import io.airbridge.deviceinfo.WifiCallback;
import io.airbridge.deviceinfo.WifiListProvider;
import io.airbridge.internal.Param;
import io.airbridge.internal.StateOwner;
import io.airbridge.internal.log.Logger;
import io.airbridge.internal.networking.ABRequest;
import io.airbridge.internal.networking.ABResponse;
import io.airbridge.statistics.EventQueue;
import io.airbridge.statistics.EventRequest;
import io.airbridge.statistics.events.DeepLinkLaunchEvent;
import io.airbridge.statistics.events.Event;
import io.airbridge.statistics.page.LifecycleTracker;
import io.airbridge.statistics.page.PageInfoRegistry;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Tracker {
    private EventQueue queue;
    private PageInfoRegistry pageInfoRegistry;
    private LifecycleTracker lifecycleTracker;
    private DeviceInfo device;
    private SharedPreferences pref;
    private Param locationInfo;
    private Param userInfo;
    private Context context;
    WifiListProvider wifiListProvider;
    InstallReferrerProvider installReferrerProvider;

    public Tracker(Context context, PageInfoRegistry pageInfoRegistry, DeviceInfo device) {
        this.context = context;
        this.queue = new EventQueue(context);
        this.pageInfoRegistry = pageInfoRegistry;
        this.device = device;
        this.pref = context.getSharedPreferences("ab_session", 0);
        this.wifiListProvider = WifiListProvider.getInstance(context);
        this.installReferrerProvider = InstallReferrerProvider.getInstance(context);
        this.queue.loadAndSend();
        this.setUserInfo();
    }

    public void setLifecycleTracker(LifecycleTracker lifecycleTracker) {
        this.lifecycleTracker = lifecycleTracker;
    }

    public void setUserEmail(String email) {
        if (this.userInfo == null) {
            this.userInfo = new Param();
        }
        String hashedEmail = this.setHashed(email);
        this.userInfo.put("externalUserEmail", hashedEmail);
        Config.getInstance().put("externalUserEmail", hashedEmail);
        Config.getInstance().save();
    }

    public void setUserId(String userId) {
        if (this.userInfo == null) {
            this.userInfo = new Param();
        }
        String hasedId = this.setHashed(userId);
        this.userInfo.put("externalUserID", hasedId);
        Config.getInstance().put("externalUserID", hasedId);
        Config.getInstance().save();
    }

    private void setUserInfo() {
        String externalUserEmail = Config.getInstance().getString("externalUserEmail", "null");
        String externalUserID = Config.getInstance().getString("externalUserID", "null");
        if (!externalUserEmail.equals("null")) {
            if (this.userInfo == null) {
                this.userInfo = new Param();
            }
            this.userInfo.put("externalUserEmail", externalUserEmail);
        }
        if (!externalUserID.equals("null")) {
            if (this.userInfo == null) {
                this.userInfo = new Param();
            }
            this.userInfo.put("externalUserID", externalUserID);
        }
    }

    public void expireUser() {
        Config.getInstance().put("externalUserEmail", "null");
        Config.getInstance().put("externalUserID", "null");
        this.userInfo = null;
    }

    public String setHashed(String data) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(data.getBytes());
            byte[] byteData = messageDigest.digest();
            StringBuffer stringBuffer = new StringBuffer();
            for (byte aByteData : byteData) {
                stringBuffer.append(Integer.toString((aByteData & 0xFF) + 256, 16).substring(1));
            }
            return stringBuffer.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return data;
        }
    }

    public void setLocationData(Location location) {
        this.locationInfo = new Param().put("latitude", location.getLatitude()).put("longitude", location.getLongitude()).put("altitude", location.getAltitude()).put("speed", Float.valueOf(location.getSpeed()));
    }

    public ArrayList<Param> setInstalledAppInfo() {
        PackageManager package_manager = this.context.getPackageManager();
        List _app_list = package_manager.getInstalledApplications(0);
        String app_local_name = "";
        String app_package_name = "";
        ArrayList<Param> installedAppsParamList = new ArrayList<Param>();
        for (ApplicationInfo appInfo : _app_list) {
            app_local_name = (String)package_manager.getApplicationLabel(appInfo);
            app_package_name = appInfo.packageName;
            long app_package_installed_time = 0L;
            Param installedAppsParam = new Param();
            try {
                PackageInfo packageInfo = package_manager.getPackageInfo(appInfo.packageName, 4096);
                app_package_installed_time = packageInfo.firstInstallTime;
                installedAppsParam.put("installTimestamp", app_package_installed_time);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            installedAppsParam.put("packageName", app_package_name);
            installedAppsParam.put("appName", app_local_name);
            installedAppsParamList.add(installedAppsParam);
        }
        return installedAppsParamList;
    }

    public void onNewIntent(Intent intent) {
        if (intent != null && "android.intent.action.VIEW".equals(intent.getAction()) && intent.getData() != null) {
            this.send(new DeepLinkLaunchEvent(intent.getDataString()));
        }
    }

    public void send(final Event event) {
        this.device.once(DeviceInfo.State.FETCHED, new StateOwner.Callback(){

            @Override
            public void call() {
                final ArrayList wifiParam = new ArrayList();
                event.onBeforeSendingEvent();
                if (!event.canBeSent()) {
                    return;
                }
                Tracker.this.saveLastEvent(event);
                Logger.d("saveEvent : " + event.getCategory(), new Object[0]);
                Tracker.this.wifiListProvider.once(WifiListProvider.State.SET, new StateOwner.Callback(){

                    @Override
                    public void call() {
                        if (event.getCategory() == 9163) {
                            Tracker.this.installReferrerProvider.once(InstallReferrerProvider.State.TAKEN, new StateOwner.Callback(){

                                @Override
                                public void call() {
                                    EventRequest request = Tracker.this.makeEventRequest(event, wifiParam);
                                    Tracker.this.queue.enqueue(request);
                                    Tracker.this.installReferrerProvider.setState(InstallReferrerProvider.State.VACANT);
                                }
                            });
                            Tracker.this.installReferrerProvider.getInstalledReferrer();
                        } else {
                            EventRequest request = Tracker.this.makeEventRequest(event, wifiParam);
                            Tracker.this.queue.enqueue(request);
                        }
                        event.onAfterSendingEvent();
                    }
                });
                Tracker.this.wifiListFetch(wifiParam);
                Logger.d("WifiList is fetched", new Object[0]);
            }
        });
    }

    public void cancelSending(int eventCategory) {
        boolean succeed = this.queue.remove(eventCategory);
        if (!succeed) {
            Logger.w("Failed to cancel " + eventCategory);
        } else {
            Logger.i("Cancelled sending a %d event.", eventCategory);
        }
    }

    public void cancelSendingBackgrundEvent() {
        boolean succeed = this.queue.removeTopEvent(9269);
        if (!succeed) {
            Logger.d("No background event exist", new Object[0]);
        } else {
            Logger.i("Cancelled sending a background event", new Object[0]);
        }
    }

    public void call(final Event event, final EventCallback callback) {
        this.device.once(DeviceInfo.State.FETCHED, new StateOwner.Callback(){

            @Override
            public void call() {
                event.onBeforeSendingEvent();
                if (!event.canBeSent()) {
                    return;
                }
                final ArrayList wifiParam = new ArrayList();
                Tracker.this.wifiListProvider.once(WifiListProvider.State.SET, new StateOwner.Callback(){

                    @Override
                    public void call() {
                        Tracker.this.installReferrerProvider.once(InstallReferrerProvider.State.TAKEN, new StateOwner.Callback(){

                            @Override
                            public void call() {
                                Tracker.this.installReferrerProvider.setState(InstallReferrerProvider.State.VACANT);
                                EventRequest request = Tracker.this.makeEventRequest(event, wifiParam);
                                request.callAsync(new ABRequest.Callback(){

                                    @Override
                                    public void done(ABRequest request, ABResponse response) {
                                        if (response.isFailed()) {
                                            Logger.e("Failed to send event.");
                                            return;
                                        }
                                        try {
                                            JSONObject json = new JSONObject(response.body);
                                            callback.done(json.getJSONObject("resource"));
                                        }
                                        catch (JSONException e) {
                                            Logger.e("Failed to parse JSON.", e);
                                        }
                                        catch (Throwable e) {
                                            Logger.wtf("An error occurred while processing event result.", e);
                                        }
                                    }
                                });
                            }
                        });
                        Tracker.this.installReferrerProvider.getInstalledReferrer();
                    }
                });
                Tracker.this.wifiListFetch(wifiParam);
            }
        });
    }

    private EventRequest makeEventRequest(Event event, List<Param> wifiListParam) {
        return this.makeEventRequestWithTime(event, System.currentTimeMillis(), wifiListParam);
    }

    private EventRequest makeEventRequestWithTime(Event event, long time, List<Param> wifiListParam) {
        Logger.i("Event occurred : %s (%d)", event.getClass().getSimpleName(), event.getCategory());
        Param deviceInfo = this.device.serialize();
        deviceInfo.maybePut("location", this.locationInfo);
        String url = "";
        if (8601 == event.getCategory()) {
            Config.getInstance().updateLastAppInfoUpdateDate();
            if (AirBridge.isInstalledAppCollectionMode) {
                deviceInfo.put("installedApps", this.setInstalledAppInfo());
            }
            url = Constants.getHost() + "/api/v2/apps/" + AirBridge.appId + "/events/batch/mobile-app/" + event.getCategory();
        } else {
            url = Constants.getHost() + "/api/v2/apps/" + AirBridge.appId + "/events/mobile-app/" + event.getCategory();
        }
        Param payload = new Param().put("eventTimestamp", time).put("sdkVersion", "M_A_v1.3.2").put("app", this.getApplicationData()).put("device", deviceInfo).maybePut("user", this.userInfo);
        Param eventData = event.getEventData(this);
        if (this.lifecycleTracker != null) {
            payload.put("limitAppTracking", !this.lifecycleTracker.isPageTrackingEnabled());
            eventData.put("sessionID", Config.getInstance().getSessionId());
            eventData.put("sessionTimeOut", String.valueOf(AirBridge.getLifecycleTime()));
            eventData.put("exActiveStatus", this.lifecycleTracker.getPreviousSessionStatus());
            eventData.put("page", this.pageInfoRegistry.getCurrentPageData());
            if (wifiListParam.size() > 0 && AirBridge.isWifiCollectionMode) {
                eventData.put("wifiSignals", wifiListParam);
            }
            if (event.getCategory() == 9163 || event.getCategory() == 9161) {
                long referrerClickTimestampSeconds = Config.getInstance().getLong("ReferrerClickTimestampSeconds", 0L) * 1000L;
                long installBeginTimestampSeconds = Config.getInstance().getLong("InstallBeginTimestampSeconds", 0L) * 1000L;
                if (referrerClickTimestampSeconds != 0L) {
                    eventData.put("systemInstallClickTimestamp", referrerClickTimestampSeconds);
                }
                if (installBeginTimestampSeconds != 0L) {
                    eventData.put("systemInstallStartTimestamp", installBeginTimestampSeconds);
                }
            }
        }
        payload.put("eventData", eventData);
        Logger.d("WifiProvider state Change TO empty On makeRequest", new Object[0]);
        this.wifiListProvider.setState(WifiListProvider.State.EMPTY);
        return new EventRequest(event.getCategory(), payload, url);
    }

    private Param getApplicationData() {
        return new Param().put("version", this.device.appVersion).put("versionCode", this.device.appVersionCode).put("packageName", this.device.packageName);
    }

    private void saveLastEvent(Event event) {
        this.pref.edit().putInt("lastEventCategory", event.getCategory()).apply();
        this.pref.edit().putLong("lastEventTime", System.currentTimeMillis() + 1000L).apply();
    }

    private void wifiListFetch(final List<Param> wifiListParam) {
        this.wifiListProvider.setResponseCallback(new WifiCallback(){

            @Override
            public void scanComplete(List<ScanResult> scanResultList) {
                if (wifiListParam.size() > 0) {
                    wifiListParam.clear();
                }
                int wifiListCounter = 0;
                for (ScanResult scanResult : scanResultList) {
                    Param wifiParam = new Param();
                    wifiParam.maybePut("bssid", scanResult.BSSID);
                    wifiParam.maybePut("ssid", scanResult.SSID);
                    int rssi = WifiManager.calculateSignalLevel((int)scanResult.level, (int)5);
                    wifiParam.maybePut("rssi", rssi);
                    wifiParam.maybePut("frequency", scanResult.frequency);
                    wifiParam.maybePut("capability", scanResult.capabilities);
                    wifiListParam.add(wifiParam);
                    if (++wifiListCounter <= 20) continue;
                    break;
                }
                Logger.d("WifiProvider state Change TO SET On scanComplete", new Object[0]);
                Tracker.this.wifiListProvider.setState(WifiListProvider.State.SET);
            }
        });
        if (!this.wifiListProvider.getWifiList()) {
            Logger.d("WifiProvider state Change TO SET On false", new Object[0]);
            this.wifiListProvider.setState(WifiListProvider.State.SET);
        }
    }

    public static interface EventCallback {
        public void done(JSONObject var1) throws Exception;
    }
}

