/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.statistics;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.MainThread;
import android.support.annotation.WorkerThread;
import io.airbridge.AirBridge;
import io.airbridge.Config;
import io.airbridge.deeplink.DeepLink;
import io.airbridge.integration.IntegrationManager;
import io.airbridge.internal.log.Logger;
import io.airbridge.internal.tasks.AirBridgeExecutor;
import io.airbridge.internal.tasks.CompletableFuture;
import io.airbridge.statistics.Attribution;
import io.airbridge.statistics.DeepLinkStatus;
import io.airbridge.statistics.Tracker;
import io.airbridge.statistics.events.InstallEvent;
import org.json.JSONObject;

public class Installer {
    public static CompletableFuture<String> referrerFuture = new CompletableFuture();
    private static boolean tooLongToDeferredAction;
    private static int referrerTimeout;
    public static boolean doReferrerTimeout;

    public static void setPlayStoreReferrerTimeout(int millis) {
        referrerTimeout = millis;
    }

    @WorkerThread
    public static void install(final Context context) {
        if (doReferrerTimeout) {
            AirBridgeExecutor.runAfterTime(referrerTimeout, new Runnable(){

                @Override
                public void run() {
                    tooLongToDeferredAction = true;
                }
            });
        }
        Config.getInstance().setInstalled();
        DeepLinkStatus deepLinkState = DeepLinkStatus.getInstance();
        if (deepLinkState.getState() == DeepLinkStatus.State.DEEP_LINK_CLICKED) {
            Logger.i("Skipping InstallEvent because the app is installed with deep link.", new Object[0]);
            deepLinkState.clear();
            return;
        }
        IntegrationManager.notifyInstalled(context);
        String referrer = referrerFuture.await(referrerTimeout);
        InstallEvent installEvent = new InstallEvent(referrer);
        AirBridge.getTracker().call(installEvent, new Tracker.EventCallback(){

            @Override
            public void done(JSONObject results) throws Exception {
                Installer.finishInstall(context, results);
            }
        });
    }

    @MainThread
    private static void finishInstall(Context context, JSONObject serverResult) throws Exception {
        if (serverResult.has("lastTouchpoint")) {
            JSONObject deferredData = serverResult.getJSONObject("lastTouchpoint");
            if (tooLongToDeferredAction) {
                Logger.i("Ignoring calling handler due to the late response from server.", new Object[0]);
            } else if (deferredData != null && deferredData.has("deeplink")) {
                String deeplink = deferredData.getString("deeplink");
                Intent intent = DeepLink.createIntent(deeplink);
                context.startActivity(intent);
            }
            Attribution attribution = new Attribution();
            attribution.load();
            attribution.updateFromServer(context);
        }
    }

    static {
        referrerTimeout = 2000;
        doReferrerTimeout = false;
    }
}

