/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.statistics;

import io.airbridge.AirBridge;
import io.airbridge.Constants;
import io.airbridge.internal.JsonConvertible;
import io.airbridge.internal.Param;
import io.airbridge.internal.log.Logger;
import io.airbridge.internal.networking.ABRequest;
import org.json.JSONException;
import org.json.JSONObject;

class EventRequest
extends ABRequest
implements JsonConvertible {
    int eventCategory;
    int retryDelay = 0;

    public EventRequest(int eventCategory, Param payload) {
        super("POST", Constants.getHost() + "/api/v2/apps/" + AirBridge.appId + "/events/mobile-app/" + eventCategory);
        this.body = payload.toJson();
        this.eventCategory = eventCategory;
    }

    public EventRequest(int eventCategory, Param payload, String url) {
        super("POST", url);
        this.body = payload.toJson();
        this.eventCategory = eventCategory;
    }

    protected EventRequest(String method, String url) {
        super(method, url);
    }

    public static EventRequest fromJson(String rawJson) throws JSONException {
        JSONObject json = new JSONObject(rawJson);
        EventRequest request = new EventRequest(json.getString("method"), json.getString("url"));
        request.body = json.getJSONObject("body");
        request.eventCategory = json.getInt("eventCategory");
        request.retryDelay = json.getInt("retryDelay");
        return request;
    }

    @Override
    public JSONObject toJson() {
        return new Param().put("method", this.method).put("url", this.url).put("body", this.body).put("eventCategory", this.eventCategory).put("retryDelay", this.retryDelay).toJson();
    }

    public ABRequest makeSecondaryServerRequest() {
        ABRequest request = new ABRequest("POST", "https://secondary.airbridge.io/sqs/airbridge-mobile-events");
        request.body = new Param().put("requestMethod", this.method).put("requestEndpoint", this.url).put("requestBody", this.body).toJson();
        Logger.d("move to secondary Queue", new Object[0]);
        return request;
    }
}

