/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.statistics;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import io.airbridge.internal.log.Logger;
import io.airbridge.internal.networking.ABRequest;
import io.airbridge.internal.networking.ABResponse;
import io.airbridge.internal.tasks.AirBridgeExecutor;
import io.airbridge.statistics.EventRequest;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import org.json.JSONArray;

public class EventQueue {
    private static final int SEND_DELAY = 5000;
    private static final IntentFilter RECONNECT_INTENT = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
    public static boolean ensureRequestMode = true;
    private volatile boolean isRequestCollectorRunning = false;
    private RequestQueue requestQueue = new RequestQueue("requestQueue");
    private RequestQueue failQueue = new RequestQueue("failQueue");
    private RequestQueue localFailQueue = new RequestQueue("localFailQueue");
    private SharedPreferences prefs;
    private ConnectivityManager cm;
    private Context context;
    private final BroadcastReceiver reconnectReceiver = new BroadcastReceiver(){

        public void onReceive(Context c, Intent intent) {
            if (EventQueue.this.isNetworkConnected()) {
                EventQueue.this.context.unregisterReceiver((BroadcastReceiver)this);
                Logger.i("Internet reconnected!", new Object[0]);
                EventQueue.this.flush(EventQueue.this.localFailQueue);
            }
        }
    };

    public EventQueue(Context context) {
        this.context = context.getApplicationContext();
        this.prefs = context.getSharedPreferences("ab_session", 0);
        this.cm = (ConnectivityManager)context.getSystemService("connectivity");
    }

    public void loadAndSend() {
        if (!ensureRequestMode) {
            return;
        }
        this.requestQueue.loadFromOffline();
        this.failQueue.loadFromOffline();
        this.localFailQueue.loadFromOffline();
        if (!this.requestQueue.isEmpty()) {
            this.flush(this.requestQueue);
        }
        if (!this.failQueue.isEmpty()) {
            this.flush(this.failQueue);
        }
        if (!this.localFailQueue.isEmpty()) {
            this.localFlush(this.localFailQueue);
        }
    }

    public void enqueue(EventRequest request) {
        if (request.eventCategory == 9162 || request.eventCategory == 9168) {
            this.removeTopEvent(9165);
            this.removeTopEvent(9166);
        } else if (request.eventCategory == 9165 || request.eventCategory == 9166) {
            if (this.isTopEvent(9162)) {
                Logger.d("ignoring " + request.eventCategory + " event caused by 9162 event", new Object[0]);
                return;
            }
            if (this.isTopEvent(9168)) {
                Logger.d("ignoring " + request.eventCategory + " event caused by 9168 event", new Object[0]);
                return;
            }
        }
        if (request.eventCategory == 9260) {
            this.removeTopEvent(9269);
        }
        if (!ensureRequestMode) {
            this.sendNow(request);
            return;
        }
        this.requestQueue.add(request);
        if (this.isRequestCollectorRunning) {
            return;
        }
        Logger.v("Collecting requests...", new Object[0]);
        this.isRequestCollectorRunning = true;
        AirBridgeExecutor.runAfterTime(5000L, new Runnable(){

            @Override
            public void run() {
                Logger.v("Finished collecting. Sending %d requests.", EventQueue.this.requestQueue.size());
                EventQueue.this.isRequestCollectorRunning = false;
                EventQueue.this.flush(EventQueue.this.requestQueue);
            }
        });
    }

    public boolean remove(int eventCategory) {
        for (EventRequest request : this.requestQueue) {
            if (request.eventCategory != eventCategory) continue;
            this.requestQueue.remove(request);
            return true;
        }
        return false;
    }

    public boolean isTopEvent(int eventCategory) {
        EventRequest lastRequest = null;
        Iterator iterator = this.requestQueue.iterator();
        while (iterator.hasNext()) {
            EventRequest request;
            lastRequest = request = (EventRequest)iterator.next();
        }
        if (lastRequest != null && lastRequest.eventCategory == eventCategory) {
            Logger.d("find " + String.valueOf(eventCategory) + " event on top of Queue", new Object[0]);
            return true;
        }
        return false;
    }

    public boolean removeTopEvent(int eventCategory) {
        EventRequest lastRequest = null;
        Iterator iterator = this.requestQueue.iterator();
        while (iterator.hasNext()) {
            EventRequest request;
            lastRequest = request = (EventRequest)iterator.next();
        }
        if (lastRequest != null && lastRequest.eventCategory == eventCategory) {
            Logger.d("Delete " + String.valueOf(eventCategory) + " event.", new Object[0]);
            this.requestQueue.remove(lastRequest);
            return true;
        }
        return false;
    }

    private void flush(RequestQueue queue) {
        EventRequest request;
        while ((request = (EventRequest)queue.poll()) != null) {
            if (request.retryDelay > 122880000) {
                ABRequest secRequest = request.makeSecondaryServerRequest();
                secRequest.callAsync();
                continue;
            }
            this.sendNow(request);
            queue.saveToOffline();
        }
    }

    private void localFlush(RequestQueue queue) {
        EventRequest request;
        RequestQueue copyQueue = new RequestQueue("copyQueue");
        while ((request = (EventRequest)queue.poll()) != null) {
            copyQueue.add(request);
        }
        while ((request = (EventRequest)copyQueue.poll()) != null) {
            if (request.retryDelay > 122880000) {
                ABRequest secRequest = request.makeSecondaryServerRequest();
                secRequest.callAsync();
                continue;
            }
            this.sendNow(request);
        }
    }

    public void sendNow(final EventRequest request) {
        if (!this.isNetworkConnected()) {
            this.localFailQueue.add(request);
            this.context.registerReceiver(this.reconnectReceiver, RECONNECT_INTENT);
            Logger.d("Internet is not connected - pending request. [failQueueLength=%d] move to localRequestQueue", this.failQueue.size());
            return;
        }
        request.callAsync(new ABRequest.Callback(){

            @Override
            public void done(ABRequest abRequest, ABResponse response) {
                if (response.isFailed()) {
                    if (response == ABResponse.ERROR_NO_NETWORK) {
                        EventQueue.this.localFailQueue.add(request);
                        EventQueue.this.context.registerReceiver(EventQueue.this.reconnectReceiver, RECONNECT_INTENT);
                        Logger.d("Internet is unstable - pending request. [localFailQueueLength=%d] move to localRequestQueue", EventQueue.this.localFailQueue.size());
                        return;
                    }
                    if (request.retryDelay > 122880000) {
                        ABRequest secRequest = request.makeSecondaryServerRequest();
                        secRequest.callAsync();
                        return;
                    }
                    request.retryDelay = request.retryDelay == 0 ? 60000 : request.retryDelay * 2;
                    EventQueue.this.failQueue.add(request);
                    AirBridgeExecutor.runAfterTime(request.retryDelay, new Runnable(){

                        @Override
                        public void run() {
                            if (EventQueue.this.failQueue.isEmpty()) {
                                return;
                            }
                            Logger.v("Retrying request after %d seconds.", request.retryDelay / 1000);
                            EventQueue.this.failQueue.remove(request);
                            EventQueue.this.sendNow(request);
                        }
                    });
                }
            }
        });
    }

    private boolean isNetworkConnected() {
        NetworkInfo activeNetwork = this.cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnectedOrConnecting();
    }

    class RequestQueue
    extends LinkedBlockingQueue<EventRequest> {
        private String name;

        public RequestQueue(String prefsKey) {
            this.name = prefsKey;
        }

        public void loadFromOffline() {
            try {
                JSONArray jsonQueue = new JSONArray(EventQueue.this.prefs.getString(this.name, "[]"));
                int length = jsonQueue.length();
                for (int i = 0; i < length; ++i) {
                    this.add(EventRequest.fromJson(jsonQueue.get(i).toString()));
                }
            }
            catch (Exception e) {
                Logger.e("Failed to load " + this.name + " from offline.", e);
            }
        }

        @Override
        public boolean add(EventRequest request) {
            boolean result = super.add(request);
            this.saveToOffline();
            return result;
        }

        @Override
        public EventRequest remove() {
            EventRequest result = (EventRequest)super.remove();
            this.saveToOffline();
            return result;
        }

        public void saveToOffline() {
            JSONArray jsonQueue = new JSONArray();
            for (EventRequest req : this) {
                jsonQueue.put((Object)req.toJson());
            }
            EventQueue.this.prefs.edit().putString(this.name, jsonQueue.toString()).apply();
        }
    }
}

