/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.statistics;

import android.content.Context;
import android.net.Uri;
import io.airbridge.AirBridge;
import io.airbridge.Config;
import io.airbridge.Constants;
import io.airbridge.deviceinfo.DeviceInfo;
import io.airbridge.integration.IntegrationManager;
import io.airbridge.internal.log.Logger;
import io.airbridge.internal.networking.ABRequest;
import io.airbridge.internal.networking.ABResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class Attribution {
    private static final List<String> ATTR_KEYS = Arrays.asList("channel", "campaign", "ad_group", "ad_creative", "content", "medium", "term");
    private static final String NAMESPACE = "attr:";
    Map<String, String> attrData = new HashMap<String, String>();

    public void load() {
        Config config = Config.getInstance();
        for (String key : ATTR_KEYS) {
            this.attrData.put(key, config.getString(NAMESPACE + key, null));
        }
    }

    public void updateFromServer(final Context context) {
        String url = Constants.getHost() + "/api/v2/apps/" + AirBridge.appId + "/events/mobile-app/9163/attribution-result?device_uuid=" + DeviceInfo.getInstance().getUUID();
        new ABRequest("GET", url).callAsync(new ABRequest.Callback(){

            @Override
            public void done(ABRequest request, ABResponse response) {
                try {
                    Logger.d("response body" + response.body, new Object[0]);
                    JSONObject attributionData = new JSONObject(response.body).getJSONObject("resource").getJSONObject("attributedTouchpoint");
                    if (attributionData.has("simplelink")) {
                        Uri uri = Uri.parse((String)attributionData.getString("simplelink"));
                        Attribution.this.saveOnlyChanged(uri, context);
                    }
                }
                catch (Throwable e) {
                    Logger.wtf("Failed to update attribution data.", e);
                }
            }
        });
    }

    private void saveOnlyChanged(Uri uri, Context context) {
        boolean changed = false;
        for (String key : ATTR_KEYS) {
            String localData = this.attrData.get(key);
            String remoteData = uri.getQueryParameter(key);
            if (remoteData == null || remoteData.equals(localData)) continue;
            this.attrData.put(key, remoteData);
            changed = true;
        }
        if (changed) {
            this.save();
            IntegrationManager.sendAttribution(this, context);
        }
    }

    private void save() {
        Config config = Config.getInstance();
        for (String key : ATTR_KEYS) {
            config.put(NAMESPACE + key, this.attrData.get(key));
        }
        config.save();
        Logger.v("Updated attribution info", new Object[0]);
    }

    public String get(String key) {
        if (!ATTR_KEYS.contains(key)) {
            throw new IllegalArgumentException("Unknown key : " + key);
        }
        return this.attrData.get(key);
    }
}

