/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.internal.tasks;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CompletableFuture<T>
implements Future<T> {
    private CountDownLatch lock = new CountDownLatch(1);
    private T data;
    private boolean done;
    private boolean cancelled;

    public void complete(T data) {
        this.data = data;
        this.done = true;
        this.lock.countDown();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelled = true;
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.lock.await();
        return this.data;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.lock.await(timeout, unit);
        return this.data;
    }

    public T await(long timeoutInMilliseconds) {
        try {
            return this.get(timeoutInMilliseconds, TimeUnit.MILLISECONDS);
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

