/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.internal.networking;

import android.os.Handler;
import android.os.Looper;
import io.airbridge.internal.log.Logger;
import io.airbridge.internal.networking.ABHttpClient;
import io.airbridge.internal.networking.ABResponse;
import io.airbridge.internal.tasks.AirBridgeExecutor;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.UUID;
import org.json.JSONObject;

public class ABRequest {
    private static ABHttpClient httpClient = new ABHttpClient();
    public String url;
    public String method;
    public JSONObject body;
    private static Handler handler;

    static void setHttpClient(ABHttpClient client) {
        httpClient = client;
    }

    public ABRequest(String method, String url) {
        this.method = method;
        this.url = url;
        this.body = new JSONObject();
    }

    public void callAsync() {
        this.callAsync(new Callback(){

            @Override
            public void done(ABRequest request, ABResponse response) {
            }
        });
    }

    public void callAsync(final Callback callback) {
        final ABRequest request = this;
        AirBridgeExecutor.runSerialTask(new Runnable(){

            @Override
            public void run() {
                try {
                    request.body.put("requestTimestamp", System.currentTimeMillis());
                    request.body.put("eventUUID", (Object)UUID.randomUUID());
                    Logger.v("Request    => %s %s", request.url, request.body);
                    final ABResponse response = httpClient.call(request);
                    Logger.v("\u2514 Response => HTTP %d, %s", response.status, response.body);
                    if (response.status == 401) {
                        throw new Exception("Wrong token. Have you checked the app name and app token?");
                    }
                    ABRequest.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            callback.done(request, response);
                        }
                    });
                }
                catch (ConnectException | UnknownHostException e) {
                    Logger.w("Request failed - Internet not connected.");
                    ABRequest.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            callback.done(request, ABResponse.ERROR_NO_NETWORK);
                        }
                    });
                }
                catch (Exception e) {
                    Logger.e("Request failed - " + request.body, e);
                    ABRequest.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            callback.done(request, ABResponse.ERROR_SEND);
                        }
                    });
                }
            }
        });
    }

    private void runOnUiThread(Runnable action) {
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        handler.post(action);
    }

    public static interface Callback {
        public void done(ABRequest var1, ABResponse var2);
    }
}

