/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.internal.networking;

import io.airbridge.AirBridge;
import io.airbridge.internal.log.Logger;
import io.airbridge.internal.networking.ABRequest;
import io.airbridge.internal.networking.ABResponse;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

class ABHttpClient {
    private static final int BUFFER_SIZE = 512;

    ABHttpClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ABResponse call(ABRequest request) throws Exception {
        HttpURLConnection connection = null;
        try {
            String line;
            int code;
            URL url = new URL(request.url);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(request.method);
            connection.setRequestProperty("Authorization", "AIRBRIDGE-APP-TOKEN " + AirBridge.appToken);
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Accept-Encoding", "utf-8");
            connection.setRequestProperty("Content-Type", "application/json");
            if (!request.method.equals("GET")) {
                connection.setDoOutput(true);
                connection.setChunkedStreamingMode(0);
                BufferedOutputStream out = new BufferedOutputStream(connection.getOutputStream(), 512);
                ((OutputStream)out).write(request.body.toString().getBytes("utf-8"));
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
            }
            InputStream stream = (code = connection.getResponseCode()) >= 400 ? connection.getErrorStream() : connection.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(stream));
            StringBuilder body = new StringBuilder();
            while ((line = in.readLine()) != null) {
                body.append(line);
            }
            in.close();
            ABResponse aBResponse = new ABResponse(code, body.toString());
            return aBResponse;
        }
        catch (OutOfMemoryError err) {
            Logger.wtf("Out of memory error occurred.", err);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return new ABResponse(1000);
    }
}

