/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.internal.log;

import android.util.Log;
import io.airbridge.AirBridge;
import io.airbridge.internal.log.CrashReporter;
import io.airbridge.internal.log.LogEntry;
import java.util.MissingFormatArgumentException;

public class Logger {
    static CrashReporter crashReporter = new CrashReporter();

    public static void v(String format, Object ... args) {
        String message;
        try {
            message = String.format(format, args);
        }
        catch (MissingFormatArgumentException e) {
            message = format;
        }
        crashReporter.record(new LogEntry("verbose", message));
        if (!AirBridge.isDebugMode) {
            return;
        }
        Log.v((String)"AirBridge", (String)message);
    }

    public static void d(String format, Object ... args) {
        String message;
        try {
            message = String.format(format, args);
        }
        catch (Exception e) {
            message = format;
        }
        crashReporter.record(new LogEntry("debug", message));
        if (!AirBridge.isAppDebuggable) {
            return;
        }
        Log.d((String)"AirBridge", (String)message);
    }

    public static void i(String format, Object ... args) {
        String message;
        try {
            message = String.format(format, args);
        }
        catch (MissingFormatArgumentException e) {
            message = format;
        }
        crashReporter.record(new LogEntry("info", message));
        Log.i((String)"AirBridge", (String)message);
    }

    public static void w(String message) {
        crashReporter.record(new LogEntry("warning", message));
        Log.w((String)"AirBridge", (String)message);
    }

    public static void w(String message, Throwable error) {
        crashReporter.record(new LogEntry("warning", message).setErrorInfo(error));
        Log.w((String)"AirBridge", (String)("Warning: " + message), (Throwable)error);
    }

    public static void e(String message, Throwable error) {
        crashReporter.record(new LogEntry("error", message).setErrorInfo(error));
        Log.e((String)"AirBridge", (String)message, (Throwable)error);
    }

    public static void e(String message) {
        crashReporter.record(new LogEntry("error", message));
        Log.e((String)"AirBridge", (String)message);
    }

    public static void wtf(String message, Throwable error) {
        crashReporter.record(new LogEntry("critical", message).setErrorInfo(error));
        Log.e((String)"AirBridge", (String)message, (Throwable)error);
        crashReporter.reportToServer();
    }

    public static String getFullLogs() {
        return crashReporter.getFullLogs();
    }
}

