/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.internal.log;

import io.airbridge.internal.JsonConvertible;
import io.airbridge.internal.Param;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.json.JSONException;
import org.json.JSONObject;

class LogEntry
implements JsonConvertible {
    long at = System.currentTimeMillis();
    String level;
    String message;
    String stackTrace;

    public static LogEntry fromJson(JSONObject json) {
        try {
            LogEntry entry = new LogEntry(json.getString("level"), json.getString("message"));
            entry.at = json.getLong("at");
            if (json.has("stackTrace")) {
                entry.stackTrace = json.getString("stackTrace");
            }
            return entry;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new LogEntry("INVALID", "INVALID");
        }
    }

    public LogEntry(String level, String message) {
        this.level = level;
        this.message = message;
    }

    public LogEntry setErrorInfo(Throwable error) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printer = new PrintWriter(stringWriter);
        error.printStackTrace(printer);
        this.stackTrace = stringWriter.toString();
        return this;
    }

    @Override
    public JSONObject toJson() {
        return new Param().put("at", this.at).put("level", this.level).put("message", this.message).maybePut("stacktrace", this.stackTrace).toJson();
    }
}

