/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.internal.log;

import android.util.Log;
import io.airbridge.AirBridge;
import io.airbridge.Constants;
import io.airbridge.deviceinfo.DeviceInfo;
import io.airbridge.internal.Param;
import io.airbridge.internal.log.LogEntry;
import io.airbridge.internal.networking.ABRequest;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;

class CrashReporter {
    private List<LogEntry> logs = new LinkedList<LogEntry>();

    CrashReporter() {
    }

    public void record(LogEntry log) {
        this.logs.add(log);
    }

    public String getFullLogs() {
        StringBuilder fullLog = new StringBuilder();
        for (LogEntry log : this.logs) {
            if ("verbose".equals(log.level)) continue;
            fullLog.append("[" + log.level + "] ").append(log.message).append("\n");
        }
        return fullLog.toString();
    }

    public void reportToServer() {
        try {
            JSONArray logEntries = new JSONArray();
            for (LogEntry log : this.logs) {
                logEntries.put((Object)log.toJson());
            }
            DeviceInfo device = DeviceInfo.getInstance();
            Param payload = new Param().put("logs", logEntries).put("logTimestamp", System.currentTimeMillis()).put("sdkVersion", "M_A_1.3.2").put("device", device.serialize()).put("app", new Param().put("version", device.appVersion).put("versionCode", device.appVersionCode).put("packageName", device.packageName));
            String url = Constants.getHost() + "/api/v2/apps/" + AirBridge.appId + "/logs/mobile-app";
            ABRequest request = new ABRequest("POST", url);
            request.body = payload.toJson();
            request.callAsync();
        }
        catch (Throwable e) {
            Log.e((String)"AirBridge", (String)"Error occurred while sending error logs to server.", (Throwable)e);
            this.record(new LogEntry("critical", "Error").setErrorInfo(e));
        }
    }
}

