/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.internal;

import android.support.annotation.NonNull;
import io.airbridge.internal.log.Logger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class StateOwner<S extends Enum> {
    private Map<S, List<Callback>> observers = new HashMap<S, List<Callback>>();
    private Map<S, List<Callback>> oneTimeCallbacks = new HashMap<S, List<Callback>>();
    protected volatile S previousState;
    protected volatile S currentState;

    public void observe(S state, Callback listener) {
        List<Callback> callbacks = this.observers.get(state);
        if (callbacks == null) {
            callbacks = new LinkedList<Callback>();
            this.observers.put(state, callbacks);
        }
        callbacks.add(listener);
    }

    public void once(S state, Callback callback) {
        if (this.currentState == state) {
            callback.call();
            return;
        }
        List<Callback> callbacks = this.oneTimeCallbacks.get(state);
        if (callbacks == null) {
            callbacks = new LinkedList<Callback>();
            this.oneTimeCallbacks.put(state, callbacks);
        }
        callbacks.add(callback);
    }

    public synchronized void setState(S state) {
        List<Callback> callbacks;
        this.previousState = this.currentState;
        this.currentState = state;
        if (this.observers.containsKey(state)) {
            callbacks = this.observers.get(state);
            for (Callback callback : callbacks) {
                callback.call();
            }
        }
        if (this.oneTimeCallbacks.containsKey(state)) {
            callbacks = this.oneTimeCallbacks.get(state);
            for (Callback callback : callbacks) {
                callback.call();
            }
            this.oneTimeCallbacks.remove(state);
        }
        if (this.previousState != null) {
            Logger.i("%s state : %s -> %s", this.getClass().getSimpleName(), ((Enum)this.previousState).name(), ((Enum)this.currentState).name());
        }
    }

    @NonNull
    public S getState() {
        return this.currentState;
    }

    public S getPreviousState() {
        return this.previousState;
    }

    public static interface Callback {
        public void call();
    }
}

