/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.internal;

import android.support.annotation.Nullable;
import io.airbridge.internal.JsonConvertible;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class Param
implements JsonConvertible {
    private HashMap<String, Object> paramMap = new HashMap();

    public Param put(String key, Object value) {
        this.paramMap.put(key, value);
        return this;
    }

    public Param put(String key, JsonConvertible value) {
        this.paramMap.put(key, value.toJson());
        return this;
    }

    public Param put(String key, Collection<? extends JsonConvertible> value) {
        ArrayList<JSONObject> jsonArray = new ArrayList<JSONObject>(value.size());
        for (JsonConvertible jsonConvertible : value) {
            jsonArray.add(jsonConvertible.toJson());
        }
        this.paramMap.put(key, new JSONArray(jsonArray));
        return this;
    }

    public Param maybePut(String key, @Nullable Object value) {
        if (value != null) {
            this.paramMap.put(key, value);
        }
        return this;
    }

    public Param maybePut(String key, @Nullable JsonConvertible value) {
        if (value != null) {
            this.paramMap.put(key, value.toJson());
        }
        return this;
    }

    public Object get(String key) {
        return this.paramMap.get(key);
    }

    public boolean isEmpty() {
        return this.paramMap.isEmpty();
    }

    @Override
    public JSONObject toJson() {
        return new JSONObject(this.paramMap);
    }

    public String toString() {
        return this.toJson().toString();
    }
}

